/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.swing.SwingUtilities;
import org.jdesktop.jdic.browser.MsgClient;
import org.jdesktop.jdic.browser.NativeEventData;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserUtil;

class NativeEventThread
extends Thread {
    private Vector webBrowsers = new Vector();
    private Vector nativeEvents = new Vector();
    private Process nativeBrowser;
    boolean eventRetBool;
    String eventRetString;
    MsgClient messenger = new MsgClient();

    NativeEventThread() {
        super("EventThread");
    }

    void attachWebBrowser(WebBrowser webBrowser) {
        int n = webBrowser.getInstanceNum();
        if (n >= this.webBrowsers.size()) {
            this.webBrowsers.setSize(n + 1);
        }
        this.webBrowsers.set(n, webBrowser);
    }

    public void run() {
        try {
            if (WebBrowser.getBrowserBinary() == null) {
                this.setBrowsersInitFailReason("BrowserBinary not set");
                WebBrowser.trace("browserBinary not set, system exit");
                return;
            }
            String string = System.getProperty("java.vm.vendor");
            if (WebBrowser.getBrowserBinary().endsWith("IeEmbed.exe") && string.startsWith("Sun")) {
                WebBrowserUtil.nativeSetEnv();
            }
            final String string2 = WebBrowser.getBrowserBinary() + " -port=" + this.messenger.getPort();
            WebBrowser.trace("Executing " + string2);
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    NativeEventThread.this.nativeBrowser = Runtime.getRuntime().exec(string2);
                    new StreamGobbler(NativeEventThread.this.nativeBrowser.getErrorStream()).start();
                    new StreamGobbler(NativeEventThread.this.nativeBrowser.getInputStream()).start();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.setBrowsersInitFailReason("Can't find native browser");
            System.out.println("Can't execute native browser. ErrMsg is " + privilegedActionException.getMessage());
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    NativeEventThread.this.messenger.connect();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Can't connect to native browser. ErrMsg is " + privilegedActionException.getMessage());
            this.setBrowsersInitFailReason("Can't connect to native browser");
            return;
        }
        while (true) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                int n = this.nativeBrowser.exitValue();
                WebBrowser.trace("Native browser died.");
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    this.processEvents();
                }
                catch (Exception exception) {
                    WebBrowser.trace("Exception occured when processEvent: " + exception.getMessage());
                    return;
                }
                try {
                    this.messenger.portListening();
                    this.processIncomingMessage(this.messenger.getMessage());
                }
                catch (Exception exception) {
                    WebBrowser.trace("Exception occured when portListening: " + exception.getMessage());
                    return;
                }
            }
        }
    }

    private WebBrowser getWebBrowserFromInstance(int n) {
        try {
            return (WebBrowser)this.webBrowsers.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWebBrowser(int n) {
        WebBrowser webBrowser = this.getWebBrowserFromInstance(n);
        if (null != webBrowser) {
            WebBrowser webBrowser2 = webBrowser;
            synchronized (webBrowser2) {
                webBrowser.notify();
            }
        }
    }

    private void processEvents() {
        int n = this.nativeEvents.size();
        for (int i = 0; i < n; ++i) {
            NativeEventData nativeEventData = (NativeEventData)this.nativeEvents.get(i);
            if (!this.processEvent(nativeEventData)) continue;
            this.nativeEvents.removeElementAt(i);
            break;
        }
    }

    private boolean processEvent(NativeEventData nativeEventData) {
        WebBrowser webBrowser = this.getWebBrowserFromInstance(nativeEventData.instance);
        if (null == webBrowser) {
            return true;
        }
        if (!webBrowser.getStatus().isInitialized() && nativeEventData.type != 0 && nativeEventData.type != 1) {
            return false;
        }
        WebBrowser.trace("Got event: type = " + nativeEventData.type + " instance = " + nativeEventData.instance);
        String string = nativeEventData.instance + "," + nativeEventData.type + ",";
        switch (nativeEventData.type) {
            case 0: 
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.messenger.sendMessage(string);
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                int n = webBrowser.getNativeWindow();
                if (0 == n) {
                    WebBrowser.trace("Can't get native window handle, please make sure the env variable JAVA_HOME has been set.");
                    break;
                }
                string = string + n;
                this.messenger.sendMessage(string);
                break;
            }
            case 4: {
                string = string + nativeEventData.rectValue.x + "," + nativeEventData.rectValue.y + "," + nativeEventData.rectValue.width + "," + nativeEventData.rectValue.height;
                this.messenger.sendMessage(string);
                break;
            }
            case 5: {
                string = string + nativeEventData.stringValue;
                this.messenger.sendMessage(string);
            }
        }
        return true;
    }

    private void processIncomingMessage(String string) {
        if (null == string || 0 == string.length()) {
            return;
        }
        int n = -1;
        String string2 = null;
        int n2 = string.indexOf(",", 0);
        int n3 = Integer.parseInt(string.substring(0, n2));
        int n4 = string.indexOf(",", n2 + 1);
        if (n4 < 0) {
            n = Integer.parseInt(string.substring(n2 + 1));
        } else {
            n = Integer.parseInt(string.substring(n2 + 1, n4));
            if (n4 + 1 < string.length()) {
                string2 = string.substring(n4 + 1);
            }
        }
        WebBrowser.trace("Got event from browser " + n3 + ", " + n + ", " + string2);
        if (3020 == n) {
            this.setBrowsersInitFailReason(string2);
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (3007 == n) {
            this.eventRetString = string2;
            this.notifyWebBrowser(n3);
            return;
        }
        final WebBrowser webBrowser = this.getWebBrowserFromInstance(n3);
        if (null == webBrowser) {
            return;
        }
        if (3021 == n) {
            webBrowser.getStatus().setInitStatus(true);
            webBrowser.getStatus().setInitFailReason("");
            return;
        }
        final WebBrowserEvent webBrowserEvent = new WebBrowserEvent(webBrowser, n, string2);
        Runnable runnable = new Runnable(){

            public void run() {
                webBrowser.dispatchWebBrowserEvent(webBrowserEvent);
            }
        };
        try {
            SwingUtilities.invokeLater(runnable);
        }
        catch (Exception exception) {
            WebBrowser.trace("Exception occured when invokeLater. ErrMsg is " + exception.getMessage());
        }
    }

    synchronized void fireNativeEvent(int n, int n2) {
        this.nativeEvents.addElement(new NativeEventData(n, n2));
    }

    synchronized void fireNativeEvent(int n, int n2, Rectangle rectangle) {
        this.nativeEvents.addElement(new NativeEventData(n, n2, rectangle));
    }

    synchronized void fireNativeEvent(int n, int n2, String string) {
        this.nativeEvents.addElement(new NativeEventData(n, n2, string));
    }

    void setBrowsersInitFailReason(String string) {
        ((WebBrowser)this.webBrowsers.elementAt(0)).getStatus().setInitFailReason(string);
    }

    class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream inputStream) {
            this.is = inputStream;
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println("+++ Ctrace: " + string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

