/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.GenericObject;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.SIPHeaderList;
import java.util.Hashtable;

class ListMap {
    private static final String SIPHEADERS_PACKAGE = "gov.nist.javax.sip.header";
    private static Hashtable headerListTable;
    private static boolean initialized;

    ListMap() {
    }

    private static void initializeListMap() {
        headerListTable = new Hashtable();
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.ExtensionHeaderImpl"), GenericObject.getClassFromName("gov.nist.javax.sip.header.ExtensionHeaderList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.Contact"), GenericObject.getClassFromName("gov.nist.javax.sip.header.ContactList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.ContentEncoding"), GenericObject.getClassFromName("gov.nist.javax.sip.header.ContentEncodingList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.Via"), GenericObject.getClassFromName("gov.nist.javax.sip.header.ViaList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.WWWAuthenticate"), GenericObject.getClassFromName("gov.nist.javax.sip.header.WWWAuthenticateList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.Accept"), GenericObject.getClassFromName("gov.nist.javax.sip.header.AcceptList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.AcceptEncoding"), GenericObject.getClassFromName("gov.nist.javax.sip.header.AcceptEncodingList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.AcceptLanguage"), GenericObject.getClassFromName("gov.nist.javax.sip.header.AcceptLanguageList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.ProxyRequire"), GenericObject.getClassFromName("gov.nist.javax.sip.header.ProxyRequireList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.Route"), GenericObject.getClassFromName("gov.nist.javax.sip.header.RouteList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.Require"), GenericObject.getClassFromName("gov.nist.javax.sip.header.RequireList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.Warning"), GenericObject.getClassFromName("gov.nist.javax.sip.header.WarningList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.Unsupported"), GenericObject.getClassFromName("gov.nist.javax.sip.header.UnsupportedList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.AlertInfo"), GenericObject.getClassFromName("gov.nist.javax.sip.header.AlertInfoList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.CallInfo"), GenericObject.getClassFromName("gov.nist.javax.sip.header.CallInfoList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.ProxyAuthenticate"), GenericObject.getClassFromName("gov.nist.javax.sip.header.ProxyAuthenticateList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.ProxyAuthorization"), GenericObject.getClassFromName("gov.nist.javax.sip.header.ProxyAuthorizationList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.Authorization"), GenericObject.getClassFromName("gov.nist.javax.sip.header.AuthorizationList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.Allow"), GenericObject.getClassFromName("gov.nist.javax.sip.header.AllowList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.RecordRoute"), GenericObject.getClassFromName("gov.nist.javax.sip.header.RecordRouteList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.ContentLanguage"), GenericObject.getClassFromName("gov.nist.javax.sip.header.ContentLanguageList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.ErrorInfo"), GenericObject.getClassFromName("gov.nist.javax.sip.header.ErrorInfoList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.Supported"), GenericObject.getClassFromName("gov.nist.javax.sip.header.SupportedList"));
        headerListTable.put(GenericObject.getClassFromName("gov.nist.javax.sip.header.InReplyTo"), GenericObject.getClassFromName("gov.nist.javax.sip.header.InReplyToList"));
        initialized = true;
    }

    protected static boolean hasList(SIPHeader sipHeader) {
        if (sipHeader instanceof SIPHeaderList) {
            return false;
        }
        Class<?> headerClass = sipHeader.getClass();
        return headerListTable.get(headerClass) != null;
    }

    protected static boolean hasList(Class sipHdrClass) {
        if (!initialized) {
            ListMap.initializeListMap();
        }
        return headerListTable.get(sipHdrClass) != null;
    }

    protected static Class getListClass(Class sipHdrClass) {
        if (!initialized) {
            ListMap.initializeListMap();
        }
        return (Class)headerListTable.get(sipHdrClass);
    }

    protected static SIPHeaderList getList(SIPHeader sipHeader) {
        if (!initialized) {
            ListMap.initializeListMap();
        }
        try {
            Class<?> headerClass = sipHeader.getClass();
            Class listClass = (Class)headerListTable.get(headerClass);
            SIPHeaderList shl = (SIPHeaderList)listClass.newInstance();
            shl.setHeaderName(sipHeader.getName());
            return shl;
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    static {
        ListMap.initializeListMap();
    }
}

