/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.sendfile;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;

public class FileSendBlock
implements LiveWritable {
    public static final int SENDTYPE_SINGLEFILE = 1;
    public static final int SENDTYPE_DIR = 2;
    private final int sendType;
    private final int fileCount;
    private final long totalFileSize;
    private final String filename;

    public static FileSendBlock readFileSendBlock(ByteBlock byteBlock) {
        int n;
        DefensiveTools.checkNull(byteBlock, "block");
        int n2 = BinaryTools.getUShort(byteBlock, 0);
        int n3 = BinaryTools.getUShort(byteBlock, 2);
        long l = BinaryTools.getUInt(byteBlock, 4);
        ByteBlock byteBlock2 = byteBlock.subBlock(8);
        for (n = 0; n < byteBlock2.getLength() && byteBlock2.get(n) != 0; ++n) {
        }
        String string = null;
        string = BinaryTools.getAsciiString(byteBlock2.subBlock(0, n));
        return new FileSendBlock(n2, string, n3, l);
    }

    public FileSendBlock(String string, long l) {
        this(1, string, 1, l);
    }

    public FileSendBlock(int n, String string, int n2, long l) {
        DefensiveTools.checkRange(n, "sendType", 0);
        DefensiveTools.checkRange(n2, "fileCount", 0);
        DefensiveTools.checkRange(l, "totalFileSize", 0);
        DefensiveTools.checkNull(string, "filename");
        this.sendType = n;
        this.fileCount = n2;
        this.totalFileSize = l;
        this.filename = string;
    }

    public final int getSendType() {
        return this.sendType;
    }

    public final int getFileCount() {
        return this.fileCount;
    }

    public final long getTotalFileSize() {
        return this.totalFileSize;
    }

    public final String getFilename() {
        return this.filename;
    }

    public void write(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.sendType);
        BinaryTools.writeUShort(outputStream, this.fileCount);
        BinaryTools.writeUInt(outputStream, this.totalFileSize);
        outputStream.write(BinaryTools.getAsciiBytes(this.filename));
        outputStream.write(new byte[46]);
    }

    public String toString() {
        return "FileSendBlock: type=" + this.sendType + (this.fileCount > 1 ? ", " + this.fileCount + " files under " + this.filename : ": " + this.filename) + ": " + this.totalFileSize + " bytes total";
    }
}

