/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.zip.ZipOutputStream;

public class Ear
extends Jar {
    private static final FileUtils fu = FileUtils.newFileUtils();
    private File deploymentDescriptor;
    private boolean descriptorAdded;

    public void setEarfile(File file) {
        this.setDestFile(file);
    }

    public void setAppxml(File file) {
        this.deploymentDescriptor = file;
        if (!this.deploymentDescriptor.exists()) {
            throw new BuildException("Deployment descriptor: " + this.deploymentDescriptor + " does not exist.");
        }
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setFile(this.deploymentDescriptor);
        zipFileSet.setFullpath("META-INF/application.xml");
        super.addFileset(zipFileSet);
    }

    public void addArchives(ZipFileSet zipFileSet) {
        zipFileSet.setPrefix("/");
        super.addFileset(zipFileSet);
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (this.deploymentDescriptor == null && !this.isInUpdateMode()) {
            throw new BuildException("appxml attribute is required", this.getLocation());
        }
        super.initZipOutputStream(zipOutputStream);
    }

    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string, int n) throws IOException {
        if (string.equalsIgnoreCase("META-INF/application.xml")) {
            if (this.deploymentDescriptor == null || !fu.fileNameEquals(this.deploymentDescriptor, file) || this.descriptorAdded) {
                this.log("Warning: selected " + this.archiveType + " files include a META-INF/application.xml which will be ignored (please use appxml attribute to " + this.archiveType + " task)", 1);
            } else {
                super.zipFile(file, zipOutputStream, string, n);
                this.descriptorAdded = true;
            }
        } else {
            super.zipFile(file, zipOutputStream, string, n);
        }
    }

    protected void cleanUp() {
        this.descriptorAdded = false;
        super.cleanUp();
    }

    public Ear() {
        this.archiveType = "ear";
        this.emptyBehavior = "create";
    }
}

