/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.groups;

import java.util.ArrayList;
import java.util.List;
import javax.validation.GroupSequence;
import org.hibernate.validator.internal.engine.groups.Group;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class Sequence {
    private static final Log log = LoggerFactory.make();
    private final Class<?> sequence;
    private List<Group> groups;
    private boolean inheritedGroupsExpanded = false;

    public Sequence(Class<?> sequence, List<Group> groups) {
        this.groups = groups;
        this.sequence = sequence;
    }

    public List<Group> getComposingGroups() {
        return this.groups;
    }

    public Class<?> getDefiningClass() {
        return this.sequence;
    }

    public void expandInheritedGroups() {
        if (this.inheritedGroupsExpanded) {
            return;
        }
        ArrayList<Group> expandedGroups = CollectionHelper.newArrayList();
        for (Group group : this.groups) {
            expandedGroups.add(group);
            this.addInheritedGroups(group, expandedGroups);
        }
        this.groups = expandedGroups;
        this.inheritedGroupsExpanded = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sequence sequence1 = (Sequence)o;
        if (this.groups != null ? !((Object)this.groups).equals(sequence1.groups) : sequence1.groups != null) {
            return false;
        }
        return !(this.sequence != null ? !this.sequence.equals(sequence1.sequence) : sequence1.sequence != null);
    }

    public int hashCode() {
        int result = this.sequence != null ? this.sequence.hashCode() : 0;
        result = 31 * result + (this.groups != null ? ((Object)this.groups).hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sequence");
        sb.append("{sequence=").append(this.sequence);
        sb.append(", groups=").append(this.groups);
        sb.append('}');
        return sb.toString();
    }

    private void addInheritedGroups(Group group, List<Group> expandedGroups) {
        for (Class<?> inheritedGroup : group.getDefiningClass().getInterfaces()) {
            if (this.isGroupSequence(inheritedGroup)) {
                throw log.getSequenceDefinitionsNotAllowedException();
            }
            Group g = new Group(inheritedGroup);
            expandedGroups.add(g);
            this.addInheritedGroups(g, expandedGroups);
        }
    }

    private boolean isGroupSequence(Class<?> clazz) {
        return clazz.getAnnotation(GroupSequence.class) != null;
    }
}

