/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Context;
import com.owlike.genson.Deserializer;
import com.owlike.genson.JsonBindingException;
import com.owlike.genson.reflect.BeanProperty;
import com.owlike.genson.stream.ObjectReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public abstract class PropertyMutator
extends BeanProperty
implements Comparable<PropertyMutator> {
    Deserializer<Object> propertyDeserializer;

    protected PropertyMutator(String name, Type type, Class<?> declaringClass, Class<?> concreteClass, Annotation[] annotations, int modifiers) {
        super(name, type, declaringClass, concreteClass, annotations, modifiers);
    }

    public Object deserialize(ObjectReader reader, Context ctx) {
        try {
            return this.propertyDeserializer.deserialize(reader, ctx);
        }
        catch (Throwable th) {
            throw this.couldNotDeserialize(th);
        }
    }

    public void deserialize(Object into, ObjectReader reader, Context ctx) {
        Object propValue = null;
        try {
            propValue = this.propertyDeserializer.deserialize(reader, ctx);
        }
        catch (Throwable th) {
            throw this.couldNotDeserialize(th);
        }
        this.mutate(into, propValue);
    }

    public abstract void mutate(Object var1, Object var2);

    @Override
    public int compareTo(PropertyMutator o) {
        return o.priority() - this.priority();
    }

    protected JsonBindingException couldNotMutate(Exception e) {
        return new JsonBindingException("Could not mutate value of property named '" + this.name + "' using mutator " + this.signature(), e);
    }

    protected JsonBindingException couldNotDeserialize(Throwable e) {
        return new JsonBindingException("Could not deserialize to property '" + this.name + "' of class " + this.declaringClass, e);
    }

    public static class FieldMutator
    extends PropertyMutator {
        protected final Field _field;

        public FieldMutator(String name, Field field, Type type, Class<?> concreteClass) {
            super(name, type, field.getDeclaringClass(), concreteClass, field.getAnnotations(), field.getModifiers());
            this._field = field;
            if (!this._field.isAccessible()) {
                this._field.setAccessible(true);
            }
        }

        @Override
        public void mutate(Object target, Object value) {
            try {
                this._field.set(target, value);
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotMutate(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotMutate(e);
            }
        }

        @Override
        public String signature() {
            return this._field.toGenericString();
        }

        @Override
        public int priority() {
            return 0;
        }
    }

    public static class MethodMutator
    extends PropertyMutator {
        protected final Method _setter;

        public MethodMutator(String name, Method setter, Type type, Class<?> concreteClass) {
            super(name, type, setter.getDeclaringClass(), concreteClass, setter.getAnnotations(), setter.getModifiers());
            this._setter = setter;
            if (!this._setter.isAccessible()) {
                this._setter.setAccessible(true);
            }
        }

        @Override
        public void mutate(Object target, Object value) {
            try {
                this._setter.invoke(target, value);
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotMutate(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotMutate(e);
            }
            catch (InvocationTargetException e) {
                throw this.couldNotMutate(e);
            }
        }

        @Override
        public String signature() {
            return this._setter.toGenericString();
        }

        @Override
        public int priority() {
            return 100;
        }
    }
}

