/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import org.jrobin.graph.DirectGif89Frame;
import org.jrobin.graph.Gif89Frame;
import org.jrobin.graph.IndexGif89Frame;
import org.jrobin.graph.ReverseColorMap;

class GifColorTable {
    private int[] theColors = new int[256];
    private int colorDepth;
    private int transparentIndex = -1;
    private int ciCount = 0;
    private ReverseColorMap ciLookup;

    GifColorTable() {
        this.ciLookup = new ReverseColorMap();
    }

    GifColorTable(Color[] colorArray) {
        int n = Math.min(this.theColors.length, colorArray.length);
        for (int i = 0; i < n; ++i) {
            this.theColors[i] = colorArray[i].getRGB();
        }
    }

    int getDepth() {
        return this.colorDepth;
    }

    int getTransparent() {
        return this.transparentIndex;
    }

    void setTransparent(int n) {
        this.transparentIndex = n;
    }

    void processPixels(Gif89Frame gif89Frame) throws IOException {
        if (gif89Frame instanceof DirectGif89Frame) {
            this.filterPixels((DirectGif89Frame)gif89Frame);
        } else {
            this.trackPixelUsage((IndexGif89Frame)gif89Frame);
        }
    }

    void closePixelProcessing() {
        this.colorDepth = this.computeColorDepth(this.ciCount);
    }

    void encode(OutputStream outputStream) throws IOException {
        int n = 1 << this.colorDepth;
        for (int i = 0; i < n; ++i) {
            outputStream.write(this.theColors[i] >> 16 & 0xFF);
            outputStream.write(this.theColors[i] >> 8 & 0xFF);
            outputStream.write(this.theColors[i] & 0xFF);
        }
    }

    private void filterPixels(DirectGif89Frame directGif89Frame) throws IOException {
        if (this.ciLookup == null) {
            throw new IOException("RGB frames require palette autodetection");
        }
        int[] nArray = (int[])directGif89Frame.getPixelSource();
        byte[] byArray = directGif89Frame.getPixelSink();
        for (int n : nArray) {
            int n2;
            if (n >>> 24 < 128) {
                if (this.transparentIndex == -1) {
                    this.transparentIndex = this.ciCount;
                } else if (n != this.theColors[this.transparentIndex]) {
                    byArray[var5_5] = (byte)this.transparentIndex;
                    continue;
                }
            }
            if ((n2 = this.ciLookup.getPaletteIndex(n & 0xFFFFFF)) == -1) {
                if (this.ciCount == 256) {
                    throw new IOException("can't encode as GIF (> 256 colors)");
                }
                this.theColors[this.ciCount] = n;
                this.ciLookup.put(n & 0xFFFFFF, this.ciCount);
                byArray[var5_5] = (byte)this.ciCount;
                ++this.ciCount;
                continue;
            }
            byArray[var5_5] = (byte)n2;
        }
    }

    private void trackPixelUsage(IndexGif89Frame indexGif89Frame) {
        byte[] byArray = (byte[])indexGif89Frame.getPixelSource();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] < this.ciCount) continue;
            this.ciCount = byArray[i] + 1;
        }
    }

    private int computeColorDepth(int n) {
        if (n <= 2) {
            return 1;
        }
        if (n <= 4) {
            return 2;
        }
        if (n <= 16) {
            return 4;
        }
        return 8;
    }
}

