/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition;

import com.hazelcast.cluster.JoinOperation;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.MigrationInfo;
import com.hazelcast.partition.PartitionRuntimeState;
import com.hazelcast.partition.PartitionServiceImpl;
import com.hazelcast.partition.Partitions;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public final class PartitionStateOperation
extends AbstractOperation
implements MigrationCycleOperation,
JoinOperation {
    private PartitionRuntimeState partitionState;

    public PartitionStateOperation(Collection<MemberImpl> members, Partitions partitions, Collection<MigrationInfo> migrationInfos, long masterTime, int version) {
        ArrayList<MemberInfo> memberInfos = new ArrayList<MemberInfo>(members.size());
        for (MemberImpl member : members) {
            memberInfos.add(new MemberInfo(member.getAddress(), member.getUuid()));
        }
        this.partitionState = new PartitionRuntimeState(memberInfos, partitions, migrationInfos, masterTime, version);
    }

    public PartitionStateOperation() {
    }

    @Override
    public void run() {
        this.partitionState.setEndpoint(this.getCallerAddress());
        PartitionServiceImpl partitionService = (PartitionServiceImpl)this.getService();
        partitionService.processPartitionRuntimeState(this.partitionState);
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.partitionState = new PartitionRuntimeState();
        this.partitionState.readData(in);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.partitionState.writeData(out);
    }
}

