/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ClassLoaderUtil {
    public static final String HAZELCAST_BASE_PACKAGE = "com.hazelcast.";
    public static final String HAZELCAST_ARRAY = "[Lcom.hazelcast.";
    private static final Map<String, Class> PRIMITIVE_CLASSES;
    private static final int MAX_PRIM_CLASSNAME_LENGTH = 7;

    public static <T> T newInstance(ClassLoader classLoader, String className) throws Exception {
        return (T)ClassLoaderUtil.newInstance(ClassLoaderUtil.loadClass(classLoader, className));
    }

    public static <T> T newInstance(Class<T> klass) throws Exception {
        Constructor<T> constructor = klass.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(new Object[0]);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        Class primitiveClass;
        if (className == null) {
            throw new IllegalArgumentException("ClassName cannot be null!");
        }
        if (className.length() <= 7 && Character.isLowerCase(className.charAt(0)) && (primitiveClass = PRIMITIVE_CLASSES.get(className)) != null) {
            return primitiveClass;
        }
        ClassLoader theClassLoader = classLoader;
        if (className.startsWith(HAZELCAST_BASE_PACKAGE) || className.startsWith(HAZELCAST_ARRAY)) {
            theClassLoader = ClassLoaderUtil.class.getClassLoader();
        }
        if (theClassLoader == null) {
            theClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (theClassLoader != null) {
            if (className.startsWith("[")) {
                return Class.forName(className, true, theClassLoader);
            }
            return theClassLoader.loadClass(className);
        }
        return Class.forName(className);
    }

    public static boolean isInternalType(Class type) {
        return type.getClassLoader() == ClassLoaderUtil.class.getClassLoader() && type.getName().startsWith(HAZELCAST_BASE_PACKAGE);
    }

    private ClassLoaderUtil() {
    }

    static {
        HashMap<String, Class<Object>> primitives = new HashMap<String, Class<Object>>(10, 1.0f);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("void", Void.TYPE);
        PRIMITIVE_CLASSES = Collections.unmodifiableMap(primitives);
    }
}

