/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;
import net.kano.joscar.snaccmd.conn.RateClassInfo;

public class RateChange
extends ConnCommand {
    public static final int CODE_RATES_CHANGED = 1;
    public static final int CODE_WARNING = 2;
    public static final int CODE_LIMITED = 3;
    public static final int CODE_LIMIT_CLEARED = 4;
    private final int code;
    private final RateClassInfo rateInfo;

    protected RateChange(SnacPacket snacPacket) {
        super(10);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.code = BinaryTools.getUShort(byteBlock, 0);
        ByteBlock byteBlock2 = byteBlock.subBlock(2);
        this.rateInfo = RateClassInfo.readRateClassInfo(byteBlock2);
    }

    public RateChange(int n, RateClassInfo rateClassInfo) {
        super(10);
        DefensiveTools.checkRange(n, "code", 0);
        this.rateInfo = rateClassInfo;
        this.code = n;
    }

    public final int getChangeCode() {
        return this.code;
    }

    public final RateClassInfo getRateInfo() {
        return this.rateInfo;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUShort(outputStream, this.code);
        if (this.rateInfo != null) {
            this.rateInfo.write(outputStream);
        }
    }

    public String toString() {
        return "RateChange (code=" + this.code + "): " + this.rateInfo;
    }
}

