/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import net.kano.joscar.CopyOnWriteArraySet;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ratelim.ConnectionQueueMgr;
import net.kano.joscar.ratelim.RateLimitingQueueMgr;
import net.kano.joscar.ratelim.RateQueue;
import net.kano.joscar.snac.ClientSnacProcessor;

class QueueRunner
implements Runnable {
    private final Object lock = new Object();
    private boolean updated = true;
    private final Set queues = new CopyOnWriteArraySet();

    QueueRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = 0L;
        block8: while (true) {
            Iterator iterator = this.lock;
            synchronized (iterator) {
                if (!this.updated) {
                    try {
                        if (l == 0L) {
                            this.lock.wait();
                        } else {
                            this.lock.wait(l);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.updated = false;
            }
            l = 0L;
            iterator = this.queues.iterator();
            while (true) {
                boolean bl;
                if (!iterator.hasNext()) continue block8;
                RateQueue rateQueue = (RateQueue)iterator.next();
                long l2 = 0L;
                RateQueue rateQueue2 = rateQueue;
                synchronized (rateQueue2) {
                    if (rateQueue.getParentMgr().isPaused() || !rateQueue.hasRequests()) {
                        continue;
                    }
                    if (this.isReady(rateQueue)) {
                        this.dequeueReady(rateQueue);
                    }
                    boolean bl2 = bl = !rateQueue.hasRequests();
                    if (!bl) {
                        l2 = this.getWaitTime(rateQueue);
                    }
                }
                if (bl) continue;
                if (l2 < 1L) {
                    l2 = 1L;
                }
                if (l != 0L && l2 >= l) continue;
                l = l2;
            }
            break;
        }
    }

    private long getWaitTime(RateQueue rateQueue) {
        return rateQueue.getRateClassMonitor().getOptimalWaitTime();
    }

    private boolean isReady(RateQueue rateQueue) {
        return this.getWaitTime(rateQueue) <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeueReady(RateQueue rateQueue) {
        ConnectionQueueMgr connectionQueueMgr = rateQueue.getParentMgr();
        ClientSnacProcessor clientSnacProcessor = connectionQueueMgr.getSnacProcessor();
        RateLimitingQueueMgr rateLimitingQueueMgr = connectionQueueMgr.getParentQueueMgr();
        RateQueue rateQueue2 = rateQueue;
        synchronized (rateQueue2) {
            while (rateQueue.hasRequests() && this.isReady(rateQueue)) {
                rateLimitingQueueMgr.sendSnac(clientSnacProcessor, rateQueue.dequeue());
            }
        }
    }

    public void update(ConnectionQueueMgr connectionQueueMgr) {
        this.forceUpdate();
    }

    public void update(RateQueue rateQueue) {
        this.forceUpdate();
    }

    public void update() {
        this.forceUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceUpdate() {
        Object object = this.lock;
        synchronized (object) {
            this.updated = true;
            this.lock.notifyAll();
        }
    }

    public void addQueue(RateQueue rateQueue) {
        DefensiveTools.checkNull(rateQueue, "queue");
        this.queues.add(rateQueue);
        this.update(rateQueue);
    }

    public void addQueues(RateQueue[] rateQueueArray) {
        DefensiveTools.checkNull(rateQueueArray, "rateQueues");
        this.queues.addAll(Arrays.asList(rateQueueArray));
    }

    public void removeQueue(RateQueue rateQueue) {
        DefensiveTools.checkNull(rateQueue, "queue");
        this.queues.remove(rateQueue);
    }

    public void removeQueues(RateQueue[] rateQueueArray) {
        DefensiveTools.checkNull(rateQueueArray, "rateQueues");
        this.queues.removeAll(Arrays.asList(rateQueueArray));
    }
}

