/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.imgstreaming;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.codec.video.ByteBuffer;
import org.jitsi.impl.neomedia.imgstreaming.DesktopInteract;
import org.jitsi.impl.neomedia.imgstreaming.DesktopInteractImpl;
import org.jitsi.impl.neomedia.imgstreaming.ImgStreamingUtils;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractVideoPullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ByteBufferPool;
import org.jitsi.impl.neomedia.jmfext.media.protocol.imgstreaming.DataSource;
import org.jitsi.util.Logger;

public class ImageStream
extends AbstractVideoPullBufferStream<DataSource> {
    private static final Logger logger = Logger.getLogger(ImageStream.class);
    private final ByteBufferPool byteBufferPool = new ByteBufferPool();
    private DesktopInteract desktopInteract = null;
    private int displayIndex = -1;
    private long seqNo = 0L;
    private int x = 0;
    private int y = 0;

    ImageStream(DataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doRead(Buffer buffer) throws IOException {
        Format format = buffer.getFormat();
        if (format == null && (format = this.getFormat()) != null) {
            buffer.setFormat(format);
        }
        if (format instanceof AVFrameFormat) {
            AVFrame frame;
            Object o = buffer.getData();
            if (o instanceof AVFrame) {
                frame = (AVFrame)o;
            } else {
                frame = new AVFrame();
                buffer.setData(frame);
            }
            AVFrameFormat avFrameFormat = (AVFrameFormat)format;
            Dimension size = avFrameFormat.getSize();
            ByteBuffer data = this.readScreenNative(size);
            if (data == null) throw new IOException("Failed to grab screen.");
            if (frame.avpicture_fill(data, avFrameFormat) < 0) {
                data.free();
                throw new IOException("avpicture_fill");
            }
        } else {
            byte[] bytes = (byte[])buffer.getData();
            Dimension size = ((VideoFormat)format).getSize();
            bytes = this.readScreen(bytes, size);
            buffer.setData(bytes);
            buffer.setOffset(0);
            buffer.setLength(bytes.length);
        }
        buffer.setHeader(null);
        buffer.setTimeStamp(System.nanoTime());
        buffer.setSequenceNumber(this.seqNo);
        buffer.setFlags(32896);
        ++this.seqNo;
    }

    public byte[] readScreen(byte[] output, Dimension dim) {
        VideoFormat format = (VideoFormat)this.getFormat();
        Dimension formatSize = format.getSize();
        int width = formatSize.width;
        int height = formatSize.height;
        BufferedImage scaledScreen = null;
        BufferedImage screen = null;
        byte[] data = null;
        int size = width * height * 4;
        if (output == null || output.length < size) {
            output = new byte[size];
        }
        if (this.desktopInteract.captureScreen(this.displayIndex, this.x, this.y, dim.width, dim.height, output)) {
            return output;
        }
        System.out.println("failed to grab with native! " + output.length);
        screen = this.desktopInteract.captureScreen();
        if (screen != null) {
            scaledScreen = ImgStreamingUtils.getScaledImage(screen, width, height, 2);
            data = ImgStreamingUtils.getImageBytes(scaledScreen, output);
        }
        screen = null;
        scaledScreen = null;
        return data;
    }

    private ByteBuffer readScreenNative(Dimension dim) {
        boolean b;
        int size = dim.width * dim.height * 4 + 8;
        ByteBuffer data = this.byteBufferPool.getBuffer(size);
        data.setLength(size);
        try {
            b = this.desktopInteract.captureScreen(this.displayIndex, this.x, this.y, dim.width, dim.height, data.getPtr(), data.getLength());
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            b = false;
        }
        if (!b) {
            data.free();
            data = null;
        }
        return data;
    }

    public void setDisplayIndex(int displayIndex) {
        this.displayIndex = displayIndex;
    }

    public void setOrigin(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void start() throws IOException {
        super.start();
        if (this.desktopInteract == null) {
            try {
                this.desktopInteract = new DesktopInteractImpl();
            }
            catch (Exception e) {
                logger.warn("Cannot create DesktopInteract object!");
            }
        }
    }

    @Override
    public void stop() throws IOException {
        try {
            if (logger.isInfoEnabled()) {
                logger.info("Stop stream");
            }
        }
        finally {
            super.stop();
            this.byteBufferPool.drain();
        }
    }
}

