/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import java.io.Serializable;
import java.util.Arrays;

public class Stack
implements Serializable {
    private static final long serialVersionUID = 3546919169401434168L;
    private static final int DEFAULT_CAPACITY = 4;
    private Object[] items = new Object[4];
    private int size = 0;

    public void clear() {
        Arrays.fill(this.items, null);
        this.size = 0;
    }

    public Object pop() {
        if (this.size == 0) {
            return null;
        }
        int pos = this.size - 1;
        Object ret = this.items[pos];
        this.items[pos] = null;
        --this.size;
        return ret;
    }

    public void push(Object obj) {
        if (this.size == this.items.length) {
            int oldLen = this.items.length;
            Object[] tmp = new Object[oldLen * 2];
            System.arraycopy(this.items, 0, tmp, 0, this.size);
            this.items = tmp;
        }
        this.items[this.size] = obj;
        ++this.size;
    }

    public void remove(Object o) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (this.items[i] != o) continue;
            System.arraycopy(this.items, i + 1, this.items, i, this.size - i - 1);
            this.items[this.size - 1] = null;
            --this.size;
            break;
        }
    }

    public Object first() {
        if (this.size == 0) {
            return null;
        }
        return this.items[this.size - 1];
    }

    public Object last() {
        if (this.size == 0) {
            return null;
        }
        return this.items[0];
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }
}

