/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.conn.ConnCommand;

public abstract class AbstractExtraInfoCmd
extends ConnCommand {
    private final ExtraInfoBlock[] extraInfos;

    protected AbstractExtraInfoCmd(int n, SnacPacket snacPacket) {
        super(n);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.extraInfos = ExtraInfoBlock.readExtraInfoBlocks(byteBlock);
    }

    protected AbstractExtraInfoCmd(int n, ExtraInfoBlock[] extraInfoBlockArray) {
        super(n);
        DefensiveTools.checkNull(extraInfoBlockArray, "blocks");
        this.extraInfos = (ExtraInfoBlock[])DefensiveTools.getNonnullArray(extraInfoBlockArray, "blocks");
    }

    public final ExtraInfoBlock[] getExtraInfos() {
        return (ExtraInfoBlock[])(this.extraInfos == null ? null : this.extraInfos.clone());
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.extraInfos != null) {
            ByteBlock.createByteBlock(this.extraInfos).write(outputStream);
        }
    }

    public String toString() {
        return MiscTools.getClassName(this) + ": blocks=" + (this.extraInfos == null ? null : Arrays.asList(this.extraInfos));
    }
}

