/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.Retry;
import com.voxeo.utils.RetryTemplate;
import java.util.concurrent.Callable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class RetryAspect {
    @Around(value="@annotation(annotation)")
    public Object doRetry(final ProceedingJoinPoint joinPoint, Retry annotation) throws Throwable {
        RetryTemplate template = new RetryTemplate();
        template.setExceptions(annotation.exceptions());
        template.setLogExceptionOnRetry(annotation.logExceptionOnRetry());
        template.setMaxAttempts(annotation.maxAttempts());
        template.setSleepBetweenRetriesMS(annotation.sleepBetweenRetriesMS());
        return template.execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return joinPoint.proceed();
                }
                catch (Throwable t) {
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    throw (Exception)t;
                }
            }
        });
    }
}

