/*
 * Decompiled with CFR 0.152.
 */
package org.jugbb.ant.propertymerge;

public class UnicodeConverter {
    private static final String HEX_DIGITS = "0123456789ABCDEF";

    private static char getHexDigit(int decimal) {
        return HEX_DIGITS.charAt(decimal & 0xF);
    }

    private static String hexValue(int value) {
        StringBuilder sb = new StringBuilder();
        sb.append(UnicodeConverter.getHexDigit(value >>> 12));
        sb.append(UnicodeConverter.getHexDigit(value >>> 8));
        sb.append(UnicodeConverter.getHexDigit(value >>> 4));
        sb.append(UnicodeConverter.getHexDigit(value));
        return sb.toString();
    }

    public static String getUnicodeLiteral(char c) {
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c < ' ' || c > '~') {
            return "\\u" + UnicodeConverter.hexValue(c);
        }
        return String.valueOf(c);
    }

    public static String getStringWithUnicodeLiterals(String source) {
        StringBuilder sb = new StringBuilder(source.length() * 5);
        for (int i = 0; i < source.length(); ++i) {
            sb.append(UnicodeConverter.getUnicodeLiteral(source.charAt(i)));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String test = "Jan hat eine h\u00f6here M\u00fccke und h\u00e4lt ein Ma\u00df";
        System.out.println(test);
        System.out.println(UnicodeConverter.getStringWithUnicodeLiterals(test));
    }
}

