/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import org.postgresql.core.ParameterList;
import org.postgresql.core.v3.CompositeParameterList;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.SimpleQuery;
import org.postgresql.core.v3.V3Query;

class CompositeQuery
implements V3Query {
    private final SimpleQuery[] subqueries;
    private final int[] offsets;

    CompositeQuery(SimpleQuery[] subqueries, int[] offsets) {
        this.subqueries = subqueries;
        this.offsets = offsets;
    }

    public ParameterList createParameterList() {
        SimpleParameterList[] subparams = new SimpleParameterList[this.subqueries.length];
        int i = 0;
        while (i < this.subqueries.length) {
            subparams[i] = (SimpleParameterList)this.subqueries[i].createParameterList();
            ++i;
        }
        return new CompositeParameterList(subparams, this.offsets);
    }

    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.subqueries[0].toString());
        int i = 1;
        while (i < this.subqueries.length) {
            sbuf.append(';');
            sbuf.append(this.subqueries[i]);
            ++i;
        }
        return sbuf.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public void close() {
        int i = 0;
        while (i < this.subqueries.length) {
            this.subqueries[i].close();
            ++i;
        }
    }

    public SimpleQuery[] getSubqueries() {
        return this.subqueries;
    }
}

