/*
 * Decompiled with CFR 0.152.
 */
package org.xmpp.jnodes.smack;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.xmpp.jnodes.RelayChannel;
import org.xmpp.jnodes.smack.JingleChannelIQ;
import org.xmpp.jnodes.smack.JingleNodesProvider;
import org.xmpp.jnodes.smack.JingleTrackerIQ;
import org.xmpp.jnodes.smack.JingleTrackerProvider;
import org.xmpp.jnodes.smack.TrackerEntry;

public class SmackServiceNode
implements ConnectionListener,
PacketListener {
    private final XMPPConnection connection;
    private final ConcurrentHashMap<String, RelayChannel> channels = new ConcurrentHashMap();
    private final LinkedHashMap<String, TrackerEntry> trackerEntries = new LinkedHashMap();
    private long timeout = 60000L;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private final AtomicInteger ids = new AtomicInteger(0);

    public SmackServiceNode(XMPPConnection connection, long timeout) {
        this.connection = connection;
        this.timeout = timeout;
        this.setup();
    }

    public SmackServiceNode(String server, int port, long timeout) {
        ConnectionConfiguration conf = new ConnectionConfiguration(server, port, server);
        conf.setSASLAuthenticationEnabled(false);
        conf.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
        this.connection = new XMPPConnection(conf);
        this.timeout = timeout;
    }

    public void connect(String user, String password) throws XMPPException {
        this.connect(user, password, false, Roster.SubscriptionMode.accept_all);
    }

    public void connect(String user, String password, boolean tryCreateAccount, Roster.SubscriptionMode mode) throws XMPPException {
        this.connection.connect();
        this.connection.addConnectionListener((ConnectionListener)this);
        if (tryCreateAccount) {
            try {
                this.connection.getAccountManager().createAccount(user, password);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {}
            }
            catch (XMPPException e) {
                // empty catch block
            }
        }
        this.connection.login(user, password);
        this.connection.getRoster().setSubscriptionMode(mode);
        this.setup();
    }

    private void setup() {
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (RelayChannel c : SmackServiceNode.this.channels.values()) {
                    long current = System.currentTimeMillis();
                    long da = current - c.getLastReceivedTimeA();
                    long db = current - c.getLastReceivedTimeB();
                    if (da <= SmackServiceNode.this.timeout && db <= SmackServiceNode.this.timeout) continue;
                    SmackServiceNode.this.removeChannel(c);
                }
            }
        }, this.timeout, this.timeout, TimeUnit.MILLISECONDS);
        this.connection.addPacketListener((PacketListener)this, new PacketFilter(){

            public boolean accept(Packet packet) {
                return packet instanceof JingleChannelIQ || packet instanceof JingleTrackerIQ;
            }
        });
    }

    public void connectionClosed() {
        this.closeAllChannels();
        this.executor.shutdownNow();
    }

    private void closeAllChannels() {
        for (RelayChannel c : this.channels.values()) {
            this.removeChannel(c);
        }
    }

    private void removeChannel(RelayChannel c) {
        this.channels.remove(c.getAttachment());
        c.close();
    }

    public void connectionClosedOnError(Exception e) {
        this.closeAllChannels();
    }

    public void reconnectingIn(int i) {
    }

    public void reconnectionSuccessful() {
    }

    public void reconnectionFailed(Exception e) {
    }

    protected IQ createUdpChannel(JingleChannelIQ iq) {
        try {
            RelayChannel rc = RelayChannel.createLocalRelayChannel("0.0.0.0", 10000, 40000);
            int id = this.ids.incrementAndGet();
            String sId = String.valueOf(id);
            rc.setAttachment(sId);
            this.channels.put(sId, rc);
            JingleChannelIQ result = new JingleChannelIQ();
            result.setType(IQ.Type.RESULT);
            result.setTo(iq.getFrom());
            result.setFrom(iq.getTo());
            result.setPacketID(iq.getPacketID());
            result.setHost(rc.getIp());
            result.setLocalport(rc.getPortA());
            result.setRemoteport(rc.getPortB());
            result.setId(sId);
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return JingleChannelIQ.createEmptyError();
        }
    }

    public void processPacket(Packet packet) {
        JingleTrackerIQ iq;
        System.out.println("Received: " + packet.toXML());
        if (packet instanceof JingleChannelIQ) {
            JingleChannelIQ request = (JingleChannelIQ)packet;
            if (request.isRequest()) {
                this.connection.sendPacket((Packet)this.createUdpChannel(request));
            }
        } else if (packet instanceof JingleTrackerIQ && (iq = (JingleTrackerIQ)packet).isRequest()) {
            JingleTrackerIQ result = this.createKnownNodes();
            result.setPacketID(packet.getPacketID());
            result.setFrom(packet.getTo());
            result.setTo(packet.getFrom());
            this.connection.sendPacket((Packet)result);
        }
    }

    public XMPPConnection getConnection() {
        return this.connection;
    }

    public static JingleChannelIQ getChannel(XMPPConnection xmppConnection, String serviceNode) {
        if (xmppConnection == null || !xmppConnection.isConnected()) {
            return null;
        }
        JingleChannelIQ iq = new JingleChannelIQ();
        iq.setFrom(xmppConnection.getUser());
        iq.setTo(serviceNode);
        PacketCollector collector = xmppConnection.createPacketCollector((PacketFilter)new PacketIDFilter(iq.getPacketID()));
        xmppConnection.sendPacket((Packet)iq);
        JingleChannelIQ result = (JingleChannelIQ)collector.nextResult(Math.round((double)SmackConfiguration.getPacketReplyTimeout() * 1.5));
        collector.cancel();
        return result;
    }

    public static JingleTrackerIQ getServices(XMPPConnection xmppConnection, String serviceNode) {
        if (xmppConnection == null || !xmppConnection.isConnected()) {
            return null;
        }
        JingleTrackerIQ iq = new JingleTrackerIQ();
        iq.setFrom(xmppConnection.getUser());
        iq.setTo(serviceNode);
        PacketCollector collector = xmppConnection.createPacketCollector((PacketFilter)new PacketIDFilter(iq.getPacketID()));
        xmppConnection.sendPacket((Packet)iq);
        Packet result = collector.nextResult(Math.round((double)SmackConfiguration.getPacketReplyTimeout() * 1.5));
        collector.cancel();
        return result instanceof JingleTrackerIQ ? (JingleTrackerIQ)result : null;
    }

    private static void deepSearch(XMPPConnection xmppConnection, int maxEntries, String startPoint, MappedNodes mappedNodes, int maxDepth, int maxSearchNodes, String protocol, ConcurrentHashMap<String, String> visited) {
        if (xmppConnection == null || !xmppConnection.isConnected()) {
            return;
        }
        if (mappedNodes.getRelayEntries().size() > maxEntries || maxDepth <= 0) {
            return;
        }
        if (startPoint.equals(xmppConnection.getUser())) {
            return;
        }
        if (visited.size() > maxSearchNodes) {
            return;
        }
        JingleTrackerIQ result = SmackServiceNode.getServices(xmppConnection, startPoint);
        visited.put(startPoint, startPoint);
        if (result != null && result.getType().equals(IQ.Type.RESULT)) {
            for (TrackerEntry entry : result.getEntries()) {
                if (entry.getType().equals((Object)TrackerEntry.Type.tracker)) {
                    mappedNodes.getTrackerEntries().put(entry.getJid(), entry);
                    SmackServiceNode.deepSearch(xmppConnection, maxEntries, entry.getJid(), mappedNodes, maxDepth - 1, maxSearchNodes, protocol, visited);
                    continue;
                }
                if (!entry.getType().equals((Object)TrackerEntry.Type.relay) || protocol != null && !protocol.equals(entry.getProtocol())) continue;
                mappedNodes.getRelayEntries().put(entry.getJid(), entry);
            }
        }
    }

    public static MappedNodes searchServices(XMPPConnection xmppConnection, int maxEntries, int maxDepth, int maxSearchNodes, String protocol) {
        return SmackServiceNode.searchServices(new ConcurrentHashMap<String, String>(), xmppConnection, maxEntries, maxDepth, maxSearchNodes, protocol);
    }

    private static MappedNodes searchServices(ConcurrentHashMap<String, String> visited, XMPPConnection xmppConnection, int maxEntries, int maxDepth, int maxSearchNodes, String protocol) {
        if (xmppConnection == null || !xmppConnection.isConnected()) {
            return null;
        }
        MappedNodes mappedNodes = new MappedNodes();
        SmackServiceNode.searchDiscoItems(xmppConnection, maxEntries, xmppConnection.getHost(), mappedNodes, maxDepth - 1, maxSearchNodes, protocol, visited);
        SmackServiceNode.deepSearch(xmppConnection, maxEntries, xmppConnection.getHost(), mappedNodes, maxDepth - 1, maxSearchNodes, protocol, visited);
        for (RosterEntry re : xmppConnection.getRoster().getEntries()) {
            Iterator i = xmppConnection.getRoster().getPresences(re.getUser());
            while (i.hasNext()) {
                Presence presence = (Presence)i.next();
                if (!presence.isAvailable()) continue;
                SmackServiceNode.deepSearch(xmppConnection, maxEntries, presence.getFrom(), mappedNodes, maxDepth - 1, maxSearchNodes, protocol, visited);
            }
        }
        return mappedNodes;
    }

    private static void searchDiscoItems(XMPPConnection xmppConnection, int maxEntries, String startPoint, MappedNodes mappedNodes, int maxDepth, int maxSearchNodes, String protocol, ConcurrentHashMap<String, String> visited) {
        DiscoverItems items = new DiscoverItems();
        items.setTo(startPoint);
        PacketCollector collector = xmppConnection.createPacketCollector((PacketFilter)new PacketIDFilter(items.getPacketID()));
        xmppConnection.sendPacket((Packet)items);
        DiscoverItems result = (DiscoverItems)collector.nextResult(Math.round((double)SmackConfiguration.getPacketReplyTimeout() * 1.5));
        if (result != null) {
            DiscoverItems.Item item;
            Iterator i = result.getItems();
            DiscoverItems.Item item2 = item = i.hasNext() ? (DiscoverItems.Item)i.next() : null;
            while (item != null) {
                SmackServiceNode.deepSearch(xmppConnection, maxEntries, item.getEntityID(), mappedNodes, maxDepth, maxSearchNodes, protocol, visited);
                item = i.hasNext() ? (DiscoverItems.Item)i.next() : null;
            }
        }
        collector.cancel();
    }

    ConcurrentHashMap<String, RelayChannel> getChannels() {
        return this.channels;
    }

    public JingleTrackerIQ createKnownNodes() {
        JingleTrackerIQ iq = new JingleTrackerIQ();
        iq.setType(IQ.Type.RESULT);
        for (TrackerEntry entry : this.trackerEntries.values()) {
            if (entry.getPolicy().equals((Object)TrackerEntry.Policy._roster)) continue;
            iq.addEntry(entry);
        }
        return iq;
    }

    public void addTrackerEntry(TrackerEntry entry) {
        this.trackerEntries.put(entry.getJid(), entry);
    }

    public void addEntries(MappedNodes entries) {
        for (TrackerEntry t : entries.getRelayEntries().values()) {
            this.addTrackerEntry(t);
        }
        for (TrackerEntry t : entries.getTrackerEntries().values()) {
            this.addTrackerEntry(t);
        }
    }

    public LinkedHashMap<String, TrackerEntry> getTrackerEntries() {
        return this.trackerEntries;
    }

    public TrackerEntry getPreferedRelay() {
        for (TrackerEntry trackerEntry : this.trackerEntries.values()) {
            if (!TrackerEntry.Type.relay.equals((Object)trackerEntry.getType())) continue;
            return trackerEntry;
        }
        return null;
    }

    static {
        ProviderManager.getInstance().addIQProvider("channel", "http://jabber.org/protocol/jinglenodes#channel", (Object)new JingleNodesProvider());
        ProviderManager.getInstance().addIQProvider("services", "http://jabber.org/protocol/jinglenodes", (Object)new JingleTrackerProvider());
    }

    public static class MappedNodes {
        final ConcurrentHashMap<String, TrackerEntry> relayEntries = new ConcurrentHashMap();
        final ConcurrentHashMap<String, TrackerEntry> trackerEntries = new ConcurrentHashMap();

        public ConcurrentHashMap<String, TrackerEntry> getRelayEntries() {
            return this.relayEntries;
        }

        public ConcurrentHashMap<String, TrackerEntry> getTrackerEntries() {
            return this.trackerEntries;
        }
    }
}

