/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.map.EntryViews;
import com.hazelcast.map.MapEventPublisher;
import com.hazelcast.map.MapServiceContext;
import com.hazelcast.map.operation.LockAwareOperation;
import com.hazelcast.map.operation.PutBackupOperation;
import com.hazelcast.map.record.Record;
import com.hazelcast.map.record.RecordInfo;
import com.hazelcast.map.record.Records;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ResponseHandler;

public abstract class BasePutOperation
extends LockAwareOperation
implements BackupAwareOperation {
    protected transient Data dataOldValue;
    protected transient EntryEventType eventType;

    public BasePutOperation(String name, Data dataKey, Data value) {
        super(name, dataKey, value, -1L);
    }

    public BasePutOperation(String name, Data dataKey, Data value, long ttl) {
        super(name, dataKey, value, ttl);
    }

    public BasePutOperation() {
    }

    @Override
    public void afterRun() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        MapEventPublisher mapEventPublisher = mapServiceContext.getMapEventPublisher();
        mapServiceContext.interceptAfterPut(this.name, this.dataValue);
        this.eventType = this.getEventType();
        mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, this.eventType, this.dataKey, this.dataOldValue, this.dataValue);
        this.invalidateNearCaches();
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            Record record = this.recordStore.getRecord(this.dataKey);
            if (record == null) {
                return;
            }
            Data valueConvertedData = mapServiceContext.toData(this.dataValue);
            EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(this.dataKey, valueConvertedData, record);
            mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
        }
    }

    private EntryEventType getEventType() {
        if (this.eventType == null) {
            this.eventType = this.dataOldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
        }
        return this.eventType;
    }

    @Override
    public boolean shouldBackup() {
        Record record = this.recordStore.getRecord(this.dataKey);
        return record != null;
    }

    @Override
    public Operation getBackupOperation() {
        Record record = this.recordStore.getRecord(this.dataKey);
        RecordInfo replicationInfo = Records.buildRecordInfo(record);
        return new PutBackupOperation(this.name, this.dataKey, this.dataValue, replicationInfo);
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public void onWaitExpire() {
        ResponseHandler responseHandler = this.getResponseHandler();
        responseHandler.sendResponse(null);
    }

    public String toString() {
        return "BasePutOperation{" + this.name + "}";
    }
}

