/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.AbstractEventData;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;

public class EntryEventData
extends AbstractEventData {
    protected Data dataKey;
    protected Data dataNewValue;
    protected Data dataOldValue;

    public EntryEventData() {
    }

    public EntryEventData(String source, String mapName, Address caller, Data dataKey, Data dataNewValue, Data dataOldValue, int eventType) {
        super(source, mapName, caller, eventType);
        this.dataKey = dataKey;
        this.dataNewValue = dataNewValue;
        this.dataOldValue = dataOldValue;
    }

    public Data getDataKey() {
        return this.dataKey;
    }

    public Data getDataNewValue() {
        return this.dataNewValue;
    }

    public Data getDataOldValue() {
        return this.dataOldValue;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        super.writeData(out);
        this.dataKey.writeData(out);
        IOUtil.writeNullableData(out, this.dataNewValue);
        IOUtil.writeNullableData(out, this.dataOldValue);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        super.readData(in);
        this.dataKey = IOUtil.readData(in);
        this.dataNewValue = IOUtil.readNullableData(in);
        this.dataOldValue = IOUtil.readNullableData(in);
    }

    public Object cloneWithoutValues() {
        return new EntryEventData(this.getSource(), this.getMapName(), this.getCaller(), this.dataKey, null, null, this.getEventType());
    }

    @Override
    public String toString() {
        return "EntryEventData{" + super.toString() + '}';
    }
}

