/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ascii;

import com.hazelcast.ascii.AbstractTextCommand;
import com.hazelcast.ascii.TextCommandConstants;
import com.hazelcast.util.StringUtil;
import java.nio.ByteBuffer;

public class NoOpCommand
extends AbstractTextCommand {
    final ByteBuffer response;

    public NoOpCommand(byte[] response) {
        super(TextCommandConstants.TextCommandType.NO_OP);
        this.response = ByteBuffer.wrap(response);
    }

    @Override
    public boolean readFrom(ByteBuffer cb) {
        return true;
    }

    @Override
    public boolean writeTo(ByteBuffer bb) {
        while (bb.hasRemaining() && this.response.hasRemaining()) {
            bb.put(this.response.get());
        }
        return !this.response.hasRemaining();
    }

    @Override
    public String toString() {
        return "NoOpCommand {" + StringUtil.bytesToString(this.response.array()) + "}";
    }
}

