/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.service;

import javax.annotation.PostConstruct;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jivesoftware.openfire.plugin.rest.controller.GroupController;
import org.jivesoftware.openfire.plugin.rest.entity.GroupEntities;
import org.jivesoftware.openfire.plugin.rest.entity.GroupEntity;
import org.jivesoftware.openfire.plugin.rest.exceptions.ServiceException;

@Path(value="restapi/v1/groups")
public class GroupService {
    private GroupController groupController;

    @PostConstruct
    public void init() {
        this.groupController = GroupController.getInstance();
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public GroupEntities getGroups() throws ServiceException {
        return new GroupEntities(this.groupController.getGroups());
    }

    @POST
    public Response createGroup(GroupEntity groupEntity) throws ServiceException {
        this.groupController.createGroup(groupEntity);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Path(value="/{groupName}")
    @Produces(value={"application/xml", "application/json"})
    public GroupEntity getGroup(@PathParam(value="groupName") String groupName) throws ServiceException {
        return this.groupController.getGroup(groupName);
    }

    @PUT
    @Path(value="/{groupName}")
    public Response updateGroup(@PathParam(value="groupName") String groupName, GroupEntity groupEntity) throws ServiceException {
        this.groupController.updateGroup(groupName, groupEntity);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @DELETE
    @Path(value="/{groupName}")
    public Response deleteGroup(@PathParam(value="groupName") String groupName) throws ServiceException {
        this.groupController.deleteGroup(groupName);
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

