/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message;

import java.nio.ByteBuffer;
import net.sf.jml.MsnContact;
import net.sf.jml.impl.AbstractMessenger;
import net.sf.jml.message.MsnMimeMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.util.Charset;
import net.sf.jml.util.StringHolder;

public final class MsnEmailNotifyMessage
extends MsnMimeMessage {
    private static final String KEY_FROM = "From";
    private static final String KEY_MESSAGE_URL = "Message-URL";
    private static final String KEY_POST_URL = "Post-URL";
    private static final String KEY_SUBJECT = "Subject";
    private static final String KEY_DEST_FOLDER = "Dest-Folder";
    private static final String KEY_FROM_ADDR = "From-Addr";
    private static final String KEY_ID = "Id";
    protected final StringHolder bodykeys = new StringHolder();
    private String from;
    private String messageURL;
    private String postURL;
    private String subject;
    private String destFolder;
    private String fromAddr;
    private Integer id;

    public MsnEmailNotifyMessage() {
        this.setContentType("text/x-msmsgsactivemailnotification; charset=UTF-8");
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public String getMessageURL() {
        return this.messageURL;
    }

    public void setMessageURL(String string) {
        this.messageURL = string;
    }

    public String getPostURL() {
        return this.postURL;
    }

    public void setPostURL(String string) {
        this.postURL = string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getDestFolder() {
        return this.destFolder;
    }

    public void setDestFolder(String string) {
        this.destFolder = string;
    }

    public String getFromAddr() {
        return this.fromAddr;
    }

    public void setFromAddr(String string) {
        this.fromAddr = string;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    protected void messageReceived(MsnSession msnSession, MsnContact msnContact) {
        super.messageReceived(msnSession, msnContact);
        ((AbstractMessenger)msnSession.getMessenger()).fireNewEmailNotificationReceived(msnSession.getSwitchboard(), this, msnContact);
    }

    protected void parseMessage(byte[] byArray) {
        super.parseMessage(byArray);
        this.setFrom(this.bodykeys.getProperty(KEY_FROM));
        this.setMessageURL(this.bodykeys.getProperty(KEY_MESSAGE_URL));
        this.setPostURL(this.bodykeys.getProperty(KEY_POST_URL));
        this.setSubject(this.bodykeys.getProperty(KEY_SUBJECT));
        this.setDestFolder(this.bodykeys.getProperty(KEY_DEST_FOLDER));
        this.setFromAddr(this.bodykeys.getProperty(KEY_FROM_ADDR));
        this.setId(this.bodykeys.getIntProperty(KEY_ID));
    }

    protected void parseBuffer(ByteBuffer byteBuffer) {
        super.parseBuffer(byteBuffer);
        this.bodykeys.parseString(Charset.decode(ByteBuffer.wrap(byteBuffer.array())));
    }
}

