/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icon;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icon.IconCommand;

public class IconDataCmd
extends IconCommand {
    public static final int CODE_DEFAULT = 0;
    private final String sn;
    private final ExtraInfoBlock iconInfo;
    private final ByteBlock iconData;

    protected IconDataCmd(SnacPacket snacPacket) {
        super(5);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock);
        this.sn = stringBlock.getString();
        ByteBlock byteBlock2 = byteBlock.subBlock(stringBlock.getTotalSize());
        this.iconInfo = ExtraInfoBlock.readExtraInfoBlock(byteBlock2);
        byteBlock2 = byteBlock2.subBlock(this.iconInfo.getTotalSize());
        int n = BinaryTools.getUShort(byteBlock2, 0);
        this.iconData = byteBlock2.subBlock(2, n);
    }

    public IconDataCmd(String string, ExtraInfoBlock extraInfoBlock, ByteBlock byteBlock) {
        super(5);
        DefensiveTools.checkNull(string, "sn");
        this.sn = string;
        this.iconInfo = extraInfoBlock;
        this.iconData = byteBlock;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final ExtraInfoBlock getIconInfo() {
        return this.iconInfo;
    }

    public final ByteBlock getIconData() {
        return this.iconData;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        OscarTools.writeScreenname(outputStream, this.sn);
        if (this.iconInfo != null) {
            this.iconInfo.write(outputStream);
            if (this.iconData != null) {
                BinaryTools.writeUShort(outputStream, this.iconData.getLength());
                this.iconData.write(outputStream);
            }
        }
    }

    public String toString() {
        return "IconDataCmd: icon for " + this.sn + ": iconInfo=<" + this.iconInfo + ">, icon=" + (this.iconData == null ? -1 : this.iconData.getLength()) + " bytes";
    }
}

