/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snac.SnacRequestSentEvent;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;

public class SnacRequest {
    public static final Object ERRTYPE_SNAC_RESPONSE_LISTENER = "ERRTYPE_SNAC_RESPONSE_LISTENER";
    private static final Logger logger = Logger.getLogger("net.kano.joscar.snac");
    private final SnacCommand command;
    private List listeners = null;
    private final Object listenerEventLock = new Object();
    private List responses = null;
    private long sentAt = -1L;
    private long reqid = -1L;
    private boolean storingResponses = false;
    private static final SnacResponseEvent[] NO_SNAC_RESPONSES = new SnacResponseEvent[0];

    public SnacRequest(SnacCommand snacCommand, SnacRequestListener snacRequestListener) {
        DefensiveTools.checkNull(snacCommand, "command");
        this.command = snacCommand;
        if (snacRequestListener != null) {
            this.addListener(snacRequestListener);
        }
    }

    final void setReqid(long l) {
        this.reqid = l;
    }

    final long getReqid() {
        return this.reqid;
    }

    public final synchronized void addListener(SnacRequestListener snacRequestListener) {
        DefensiveTools.checkNull(snacRequestListener, "l");
        if (this.listeners == null) {
            this.listeners = new ArrayList(4);
        }
        this.listeners.add(snacRequestListener);
    }

    public final synchronized void removeListener(SnacRequestListener snacRequestListener) {
        DefensiveTools.checkNull(snacRequestListener, "l");
        if (this.listeners != null) {
            this.listeners.remove(snacRequestListener);
        }
    }

    public final synchronized boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public final SnacCommand getCommand() {
        return this.command;
    }

    public boolean isStoringResponses() {
        return this.storingResponses;
    }

    public void setStoringResponses(boolean bl) {
        this.storingResponses = bl;
    }

    public final synchronized long getSentTime() {
        return this.sentAt;
    }

    public final synchronized SnacResponseEvent[] getResponses() {
        if (this.responses == null || this.responses.isEmpty()) {
            return NO_SNAC_RESPONSES;
        }
        return this.responses.toArray(new SnacResponseEvent[this.responses.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sent(SnacRequestSentEvent snacRequestSentEvent) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.finer("Snac request sent: " + this);
        }
        Object object = this;
        synchronized (object) {
            this.sentAt = snacRequestSentEvent.getSentTime();
        }
        object = this.getListenersCopy();
        if (object != null) {
            Object object2 = this.listenerEventLock;
            synchronized (object2) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SnacRequestListener snacRequestListener = (SnacRequestListener)iterator.next();
                    if (bl) {
                        logger.finer("Running response listener " + snacRequestListener);
                    }
                    try {
                        snacRequestListener.handleSent(snacRequestSentEvent);
                    }
                    catch (Throwable throwable) {
                        snacRequestSentEvent.getFlapProcessor().handleException(ERRTYPE_SNAC_RESPONSE_LISTENER, throwable, snacRequestListener);
                    }
                }
            }
        }
        if (bl) {
            logger.finer("Finished processing Snac request send");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getListenersCopy() {
        List list;
        SnacRequest snacRequest = this;
        synchronized (snacRequest) {
            list = this.listeners;
            if (list != null && list.isEmpty()) {
                list = null;
            }
        }
        if (list != null) {
            return new ArrayList(list);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void gotResponse(SnacResponseEvent snacResponseEvent) {
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.finer("Processing response " + snacResponseEvent.getSnacPacket() + " to Snac request " + this);
        }
        Object object = this;
        synchronized (object) {
            if (this.storingResponses) {
                if (this.responses == null) {
                    this.responses = new ArrayList(5);
                }
                this.responses.add(snacResponseEvent);
            }
        }
        object = this.getListenersCopy();
        if (object != null) {
            Object object2 = this.listenerEventLock;
            synchronized (object2) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    SnacRequestListener snacRequestListener = (SnacRequestListener)iterator.next();
                    if (bl) {
                        logger.finer("Running response listener " + snacRequestListener);
                    }
                    try {
                        snacRequestListener.handleResponse(snacResponseEvent);
                    }
                    catch (Throwable throwable) {
                        snacResponseEvent.getFlapProcessor().handleException(ERRTYPE_SNAC_RESPONSE_LISTENER, throwable, snacRequestListener);
                    }
                }
            }
        }
        if (bl) {
            logger.finer("Finished handling response");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void timedOut(SnacRequestTimeoutEvent snacRequestTimeoutEvent) {
        List list;
        boolean bl = logger.isLoggable(Level.FINER);
        if (bl) {
            logger.finer("Snac request " + this + " timed out");
        }
        if ((list = this.getListenersCopy()) != null) {
            Object object = this.listenerEventLock;
            synchronized (object) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    SnacRequestListener snacRequestListener = (SnacRequestListener)iterator.next();
                    if (bl) {
                        logger.finer("Running response listener " + snacRequestListener + " for request timeout");
                    }
                    try {
                        snacRequestListener.handleTimeout(snacRequestTimeoutEvent);
                    }
                    catch (Throwable throwable) {
                        snacRequestTimeoutEvent.getFlapProcessor().handleException(ERRTYPE_SNAC_RESPONSE_LISTENER, throwable, snacRequestListener);
                    }
                }
            }
        }
        if (bl) {
            logger.finer("Finished handling Snac request timeout");
        }
    }

    public synchronized String toString() {
        return "SnacRequest for " + this.command + ": listeners: " + this.listeners + ", responses: " + this.responses;
    }
}

