/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;

public abstract class AbstractIcbm
extends SnacCommand {
    public static final int CHANNEL_IM = 1;
    public static final int CHANNEL_RV = 2;
    public static final int CHANNEL_CHAT = 3;
    private final long messageId;
    private final int channel;
    private final ByteBlock channelData;

    public static final int getIcbmChannel(SnacPacket snacPacket) {
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        return BinaryTools.getUShort(byteBlock, 8);
    }

    protected AbstractIcbm(int n, int n2, SnacPacket snacPacket) {
        super(n, n2);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.messageId = BinaryTools.getLong(byteBlock, 0);
        this.channel = BinaryTools.getUShort(byteBlock, 8);
        this.channelData = byteBlock.subBlock(10);
    }

    protected AbstractIcbm(int n, int n2, long l, int n3) {
        super(n, n2);
        DefensiveTools.checkRange(n3, "channel", 0);
        this.messageId = l;
        this.channel = n3;
        this.channelData = null;
    }

    public final long getIcbmMessageId() {
        return this.messageId;
    }

    public final int getChannel() {
        return this.channel;
    }

    protected final ByteBlock getChannelData() {
        return this.channelData;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeLong(outputStream, this.messageId);
        BinaryTools.writeUShort(outputStream, this.channel);
        this.writeChannelData(outputStream);
    }

    protected abstract void writeChannelData(OutputStream var1) throws IOException;

    public String toString() {
        return MiscTools.getClassName(this) + ": channel=" + this.channel + ", messageId=" + this.getIcbmMessageId();
    }
}

