/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipScanner;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZipFileSet
extends FileSet {
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    private File srcFile;
    private String prefix;
    private String fullpath;
    private boolean hasDir;
    private int fileMode;
    private int dirMode;
    private boolean fileModeHasBeenSet;
    private boolean dirModeHasBeenSet;

    public void setDir(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.srcFile != null) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        super.setDir(file);
        this.hasDir = true;
    }

    public void setSrc(File file) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.hasDir) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        this.srcFile = file;
    }

    public File getSrc(Project project) {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(project)).getSrc(project);
        }
        return this.srcFile;
    }

    public void setPrefix(String string) {
        if (!string.equals("") && !this.fullpath.equals("")) {
            throw new BuildException("Cannot set both fullpath and prefix attributes");
        }
        this.prefix = string;
    }

    public String getPrefix(Project project) {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(project)).getPrefix(project);
        }
        return this.prefix;
    }

    public void setFullpath(String string) {
        if (!this.prefix.equals("") && !string.equals("")) {
            throw new BuildException("Cannot set both fullpath and prefix attributes");
        }
        this.fullpath = string;
    }

    public String getFullpath(Project project) {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(project)).getFullpath(project);
        }
        return this.fullpath;
    }

    public DirectoryScanner getDirectoryScanner(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getDirectoryScanner(project);
        }
        if (this.srcFile != null) {
            ZipScanner zipScanner = new ZipScanner();
            zipScanner.setSrc(this.srcFile);
            super.setDir(project.getBaseDir());
            this.setupDirectoryScanner(zipScanner, project);
            zipScanner.init();
            return zipScanner;
        }
        return super.getDirectoryScanner(project);
    }

    public void setFileMode(String string) {
        this.fileModeHasBeenSet = true;
        this.fileMode = 0x8000 | Integer.parseInt(string, 8);
    }

    public int getFileMode(Project project) {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(project)).getFileMode(project);
        }
        return this.fileMode;
    }

    public boolean hasFileModeBeenSet() {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(this.getProject())).hasFileModeBeenSet();
        }
        return this.fileModeHasBeenSet;
    }

    public void setDirMode(String string) {
        this.dirModeHasBeenSet = true;
        this.dirMode = 0x4000 | Integer.parseInt(string, 8);
    }

    public int getDirMode(Project project) {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(project)).getDirMode(project);
        }
        return this.dirMode;
    }

    public boolean hasDirModeBeenSet() {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(this.getProject())).hasDirModeBeenSet();
        }
        return this.dirModeHasBeenSet;
    }

    protected AbstractFileSet getRef(Project project) {
        Object object;
        if (!this.isChecked()) {
            object = new Stack<ZipFileSet>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, project);
        }
        if ((object = this.getRefid().getReferencedObject(project)) instanceof ZipFileSet) {
            return (AbstractFileSet)object;
        }
        if (object instanceof FileSet) {
            ZipFileSet zipFileSet = new ZipFileSet((FileSet)object);
            zipFileSet.setPrefix(this.prefix);
            zipFileSet.setFullpath(this.fullpath);
            zipFileSet.fileModeHasBeenSet = this.fileModeHasBeenSet;
            zipFileSet.fileMode = this.fileMode;
            zipFileSet.dirModeHasBeenSet = this.dirModeHasBeenSet;
            zipFileSet.dirMode = this.dirMode;
            return zipFileSet;
        }
        String string = this.getRefid().getRefId() + " doesn't denote a zipfileset or a fileset";
        throw new BuildException(string);
    }

    public Object clone() {
        if (this.isReference()) {
            return ((ZipFileSet)this.getRef(this.getProject())).clone();
        }
        return super.clone();
    }

    private final /* synthetic */ void this() {
        this.srcFile = null;
        this.prefix = "";
        this.fullpath = "";
        this.hasDir = false;
        this.fileMode = 33188;
        this.dirMode = 16877;
        this.fileModeHasBeenSet = false;
        this.dirModeHasBeenSet = false;
    }

    public ZipFileSet() {
        this.this();
    }

    protected ZipFileSet(FileSet fileSet) {
        super(fileSet);
        this.this();
    }

    protected ZipFileSet(ZipFileSet zipFileSet) {
        super(zipFileSet);
        this.this();
        this.srcFile = zipFileSet.srcFile;
        this.prefix = zipFileSet.prefix;
        this.fullpath = zipFileSet.fullpath;
        this.hasDir = zipFileSet.hasDir;
        this.fileMode = zipFileSet.fileMode;
        this.dirMode = zipFileSet.dirMode;
        this.fileModeHasBeenSet = zipFileSet.fileModeHasBeenSet;
        this.dirModeHasBeenSet = zipFileSet.dirModeHasBeenSet;
    }
}

