/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.Writable;

public final class ByteBlock
implements Writable,
Serializable {
    public static final ByteBlock EMPTY_BLOCK = new ByteBlock();
    private final byte[] bytes;
    private final int offset;
    private final int len;
    private int hashCode = 0;

    public static ByteBlock wrap(byte[] bytes) throws IllegalArgumentException {
        return new ByteBlock(bytes, 0, bytes.length);
    }

    public static ByteBlock wrap(byte[] bytes, int offset) throws IllegalArgumentException, IndexOutOfBoundsException {
        return new ByteBlock(bytes, offset, bytes.length - offset);
    }

    public static ByteBlock wrap(byte[] bytes, int offset, int len) throws IllegalArgumentException, IndexOutOfBoundsException {
        return new ByteBlock(bytes, offset, len);
    }

    public static ByteBlock createByteBlock(LiveWritable writable) throws ArrayIndexOutOfBoundsException {
        int len;
        int offset;
        byte[] bytes;
        if (writable instanceof ByteBlock) {
            ByteBlock block = (ByteBlock)writable;
            bytes = block.bytes;
            offset = block.offset;
            len = block.len;
        } else {
            ByteArrayOutputStream out;
            if (writable instanceof Writable) {
                long writableLength = ((Writable)writable).getWritableLength();
                if (writableLength > Integer.MAX_VALUE) {
                    throw new ArrayIndexOutOfBoundsException("writable length of " + writable + " is " + writableLength + ", must be <= Integer.MAX_VALUE (" + Integer.MAX_VALUE + ")");
                }
                out = new ByteArrayOutputStream((int)writableLength);
            } else {
                out = new ByteArrayOutputStream();
            }
            try {
                writable.write(out);
            }
            catch (IOException impossible) {
                // empty catch block
            }
            bytes = out.toByteArray();
            offset = 0;
            len = bytes.length;
        }
        return ByteBlock.wrap(bytes, offset, len);
    }

    public static ByteBlock createByteBlock(LiveWritable[] writables) throws ArrayIndexOutOfBoundsException {
        if (writables.length == 0) {
            return EMPTY_BLOCK;
        }
        if (writables.length == 1) {
            return ByteBlock.createByteBlock(writables[0]);
        }
        long ttlSize = 0L;
        boolean good = true;
        for (int i = 0; i < writables.length; ++i) {
            if (!(writables[i] instanceof Writable)) {
                good = false;
                break;
            }
            long len = ((Writable)writables[i]).getWritableLength();
            ttlSize += len;
        }
        if (ttlSize > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("sum of writable length of writables is " + ttlSize + ", must be <= " + "Integer.MAX_VALUE (" + Integer.MAX_VALUE + ")");
        }
        ByteArrayOutputStream out = good ? new ByteArrayOutputStream((int)ttlSize) : new ByteArrayOutputStream();
        try {
            for (int i = 0; i < writables.length; ++i) {
                writables[i].write(out);
            }
        }
        catch (IOException impossible) {
            // empty catch block
        }
        return ByteBlock.wrap(out.toByteArray());
    }

    public static String createString(ByteBlock block, String charset) throws UnsupportedEncodingException {
        return new String(block.bytes, block.offset, block.len, charset);
    }

    public static InputStream createInputStream(ByteBlock data) {
        return new ByteArrayInputStream(data.bytes, data.offset, data.len);
    }

    private ByteBlock() {
        this.bytes = new byte[0];
        this.offset = 0;
        this.len = 0;
    }

    private ByteBlock(byte[] bytes, int offset, int len) throws IllegalArgumentException, IndexOutOfBoundsException {
        DefensiveTools.checkNull(bytes, "bytes");
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") < 0");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("length (" + len + ") < 0");
        }
        if (len + offset > bytes.length) {
            throw new IndexOutOfBoundsException("len + offset (" + (len + offset) + ") > data length (" + bytes.length + ")");
        }
        this.bytes = bytes;
        this.offset = offset;
        this.len = len;
    }

    public final byte get(int index) throws IndexOutOfBoundsException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index (" + index + ") must be >= 0");
        }
        if (index >= this.len) {
            throw new IndexOutOfBoundsException("index (" + index + ") must be less than length (" + this.len + ")");
        }
        return this.bytes[this.offset + index];
    }

    public int getLength() {
        return this.len;
    }

    public long getWritableLength() {
        return this.getLength();
    }

    public void write(OutputStream stream) throws IOException {
        DefensiveTools.checkNull(stream, "stream");
        stream.write(this.bytes, this.offset, this.len);
    }

    public byte[] toByteArray() {
        if (this.offset == 0 && this.len == this.bytes.length) {
            return (byte[])this.bytes.clone();
        }
        byte[] array = new byte[this.len];
        System.arraycopy(this.bytes, this.offset, array, 0, this.len);
        return array;
    }

    public ByteBlock subBlock(int offset) throws IndexOutOfBoundsException {
        return this.subBlock(offset, this.len - offset);
    }

    public ByteBlock subBlock(int offset, int len) throws IndexOutOfBoundsException {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset (" + offset + ") < 0");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len (" + len + ") < 0");
        }
        if (len + offset > this.len) {
            throw new IndexOutOfBoundsException("length + offset (" + (len + offset) + ") > length (" + this.len + ")");
        }
        return ByteBlock.wrap(this.bytes, this.offset + offset, len);
    }

    public int getOffset() {
        return this.offset;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("offset", 0);
        fields.put("len", this.len);
        byte[] array = this.offset == 0 && this.len == this.bytes.length ? this.bytes : this.toByteArray();
        fields.put("bytes", array);
        out.writeFields();
    }

    public void copyTo(byte[] dest, int destOffset) {
        System.arraycopy(this.bytes, this.offset, dest, destOffset, this.len);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteBlock)) {
            return false;
        }
        ByteBlock other = (ByteBlock)o;
        if (this.len != other.len) {
            return false;
        }
        int thiscode = this.hashCode;
        int othercode = other.hashCode;
        if (thiscode != 0 && othercode != 0 && thiscode != othercode) {
            return false;
        }
        if (this.offset == 0 && other.offset == 0 && this.len == this.bytes.length) {
            return Arrays.equals(this.bytes, other.bytes);
        }
        for (int i = 0; i < this.len; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int current = this.hashCode;
        if (current != 0) {
            return current;
        }
        int code = 0;
        int delta = Math.max(1, this.len / 128);
        int lim = this.offset + this.len;
        for (int i = this.offset; i < lim; i += delta) {
            code = code * 29 + this.bytes[i];
        }
        if (code == 0) {
            code = 1;
        }
        this.hashCode = code;
        return code;
    }

    public String toString() {
        return BinaryTools.describeData(this);
    }
}

