/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.impl;

import net.sf.jml.Email;
import net.sf.jml.MsnClientId;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnOwner;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnUserPropertyType;
import net.sf.jml.MsnUserStatus;
import net.sf.jml.impl.MsnUserImpl;
import net.sf.jml.protocol.outgoing.OutgoingBLP;
import net.sf.jml.protocol.outgoing.OutgoingCHG;
import net.sf.jml.protocol.outgoing.OutgoingGTC;
import net.sf.jml.protocol.outgoing.OutgoingPRP;
import net.sf.jml.protocol.outgoing.OutgoingREA;
import net.sf.jml.util.StringUtils;

public class MsnOwnerImpl
extends MsnUserImpl
implements MsnOwner {
    private final MsnMessenger messenger;
    private final String password;
    private boolean verified;
    private boolean onlyNotifyAllowList;
    private boolean notifyMeWhenSomeoneAddedMe;
    private MsnUserStatus initStatus = MsnUserStatus.ONLINE;

    public MsnOwnerImpl(MsnMessenger msnMessenger, Email email, String string) {
        this.messenger = msnMessenger;
        this.password = string;
        this.setEmail(email);
    }

    public MsnMessenger getMessenger() {
        return this.messenger;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public MsnUserStatus getInitStatus() {
        return this.initStatus;
    }

    public void setInitStatus(MsnUserStatus msnUserStatus) {
        if (msnUserStatus == MsnUserStatus.OFFLINE) {
            throw new IllegalArgumentException(msnUserStatus.toString());
        }
        this.initStatus = msnUserStatus;
    }

    public boolean isOnlyNotifyAllowList() {
        return this.onlyNotifyAllowList;
    }

    public boolean isNotifyMeWhenSomeoneAddedMe() {
        return this.notifyMeWhenSomeoneAddedMe;
    }

    public void setDisplayName(String string) {
        if (string != null) {
            MsnProtocol msnProtocol = this.messenger.getActualMsnProtocol();
            if (msnProtocol.after(MsnProtocol.MSNP9)) {
                this.setProperty(MsnUserPropertyType.MFN, StringUtils.urlEncode(string));
            } else {
                OutgoingREA outgoingREA = new OutgoingREA(msnProtocol);
                outgoingREA.setId(this.getEmail().getEmailAddress());
                outgoingREA.setFriendlyName(string);
                this.messenger.send(outgoingREA);
            }
        }
    }

    public void setClientId(MsnClientId msnClientId) {
        if (msnClientId != null && !msnClientId.equals(this.getClientId())) {
            OutgoingCHG outgoingCHG = new OutgoingCHG(this.messenger.getActualMsnProtocol());
            outgoingCHG.setClientId(msnClientId);
            outgoingCHG.setStatus(this.getStatus());
            this.messenger.send(outgoingCHG);
        }
    }

    public void setStatus(MsnUserStatus msnUserStatus) {
        if (msnUserStatus != null && msnUserStatus != MsnUserStatus.OFFLINE && msnUserStatus != this.getStatus()) {
            OutgoingCHG outgoingCHG = new OutgoingCHG(this.messenger.getActualMsnProtocol());
            outgoingCHG.setClientId(this.getClientId());
            outgoingCHG.setStatus(msnUserStatus);
            this.messenger.send(outgoingCHG);
        }
    }

    public void setProperty(MsnUserPropertyType msnUserPropertyType, String string) {
        if (msnUserPropertyType != null) {
            OutgoingPRP outgoingPRP = new OutgoingPRP(this.messenger.getActualMsnProtocol());
            outgoingPRP.setPropertyType(msnUserPropertyType);
            outgoingPRP.setProperty(string);
            this.messenger.send(outgoingPRP);
        }
    }

    public void setOnlyNotifyAllowList(boolean bl) {
        if (bl != this.isOnlyNotifyAllowList()) {
            OutgoingBLP outgoingBLP = new OutgoingBLP(this.messenger.getActualMsnProtocol());
            outgoingBLP.setOnlyNotifyAllowList(bl);
            this.messenger.send(outgoingBLP);
        }
    }

    public void setNotifyMeWhenSomeoneAddedMe(boolean bl) {
        if (bl != this.isNotifyMeWhenSomeoneAddedMe()) {
            OutgoingGTC outgoingGTC = new OutgoingGTC(this.messenger.getActualMsnProtocol());
            outgoingGTC.setNotifyMeWhenSomeoneAddedMe(bl);
            this.messenger.send(outgoingGTC);
        }
    }

    public String toString() {
        return "MsnOwner: [Email] " + this.getEmail() + " [DisplayName] " + this.getDisplayName() + " [Status] " + this.getStatus();
    }

    public void setVerified(boolean bl) {
        this.verified = bl;
    }

    public String getPassword() {
        return this.password;
    }

    public void fSetDisplayName(String string) {
        super.setDisplayName(string);
    }

    public void fSetClientId(MsnClientId msnClientId) {
        super.setClientId(msnClientId);
    }

    public void fSetStatusF(MsnUserStatus msnUserStatus) {
        super.setStatus(msnUserStatus);
    }

    public void fSetNotifyMeWhenSomeoneAddedMe(boolean bl) {
        this.notifyMeWhenSomeoneAddedMe = bl;
    }

    public void fSetOnlyNotifyAllowList(boolean bl) {
        this.onlyNotifyAllowList = bl;
    }
}

