/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.InfoData;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class UserInfoCmd
extends LocCommand {
    private final FullUserInfo userInfo;
    private final InfoData infoData;

    protected UserInfoCmd(SnacPacket snacPacket) {
        super(6);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.userInfo = FullUserInfo.readUserInfo(byteBlock);
        ByteBlock byteBlock2 = byteBlock.subBlock(this.userInfo.getTotalSize());
        this.infoData = InfoData.readInfoData(byteBlock2);
    }

    public UserInfoCmd(FullUserInfo fullUserInfo, InfoData infoData) {
        super(6);
        this.userInfo = fullUserInfo;
        this.infoData = infoData;
    }

    public final FullUserInfo getUserInfo() {
        return this.userInfo;
    }

    public final InfoData getInfoData() {
        return this.infoData;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.userInfo != null) {
            this.userInfo.write(outputStream);
            if (this.infoData != null) {
                this.infoData.write(outputStream);
            }
        }
    }

    public String toString() {
        return "UserInfoCmd: user=<" + this.userInfo + ">, info=<" + this.infoData + ">";
    }
}

