/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import net.sf.jqql.net.HttpProxy;
import net.sf.jqql.net.IProxy;
import net.sf.jqql.net.IProxyHandler;
import net.sf.jqql.net.PortGate;
import net.sf.jqql.net.Socks5Proxy;

public class ProxyVerifier
implements IProxyHandler {
    private IProxy proxy;
    private IProxyHandler handler;
    private PortGate pool;

    public ProxyVerifier(IProxyHandler iProxyHandler, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, String string, boolean bl, String string2, String string3) throws IOException {
        this.handler = iProxyHandler;
        this.pool = new PortGate();
        this.pool.start();
        if (string.equalsIgnoreCase("Socks5")) {
            if (bl) {
                DatagramChannel datagramChannel = DatagramChannel.open();
                datagramChannel.configureBlocking(false);
                this.proxy = new Socks5Proxy(this, string2, string3, datagramChannel);
            } else {
                this.proxy = new Socks5Proxy(this, string2, string3);
            }
            this.proxy.setClientPort(5678);
            this.proxy.setProxyAddress(inetSocketAddress);
            this.proxy.setRemoteAddress(inetSocketAddress2);
            this.pool.getPorter().wakeup(this.proxy);
        } else if (string.equalsIgnoreCase("Http")) {
            this.proxy = new HttpProxy(this, string2, string3);
            this.proxy.setProxyAddress(inetSocketAddress);
            this.proxy.setRemoteAddress(inetSocketAddress2);
            this.pool.getPorter().wakeup(this.proxy);
        } else {
            this.proxyAuthFail();
        }
    }

    public void start() {
        this.proxy.start();
    }

    public void dispose() {
        this.pool.dispose();
    }

    public void proxyReady(InetSocketAddress inetSocketAddress) throws IOException {
        this.dispose();
        this.handler.proxyReady(inetSocketAddress);
    }

    public void proxyAuthFail() {
        this.dispose();
        this.handler.proxyAuthFail();
    }

    public void proxyError(String string) {
        this.dispose();
        this.handler.proxyError(string);
    }
}

