/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.proxy;

import com.hazelcast.concurrent.lock.GetLockCountOperation;
import com.hazelcast.concurrent.lock.GetRemainingLeaseTimeOperation;
import com.hazelcast.concurrent.lock.IsLockedOperation;
import com.hazelcast.concurrent.lock.LockOperation;
import com.hazelcast.concurrent.lock.UnlockOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class LockProxySupport {
    private final ObjectNamespace namespace;

    public LockProxySupport(ObjectNamespace namespace) {
        this.namespace = namespace;
    }

    public boolean isLocked(NodeEngine nodeEngine, Data key) {
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        IsLockedOperation operation = new IsLockedOperation(this.namespace, key);
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)operation, partitionId).build();
            Future future = invocation.invoke();
            return (Boolean)future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public boolean isLockedByCurrentThread(NodeEngine nodeEngine, Data key) {
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        IsLockedOperation operation = new IsLockedOperation(this.namespace, key, ThreadUtil.getThreadId());
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)operation, partitionId).build();
            Future future = invocation.invoke();
            return (Boolean)future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public int getLockCount(NodeEngine nodeEngine, Data key) {
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        GetLockCountOperation operation = new GetLockCountOperation(this.namespace, key);
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)operation, partitionId).build();
            Future future = invocation.invoke();
            return ((Number)future.get()).intValue();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public long getRemainingLeaseTime(NodeEngine nodeEngine, Data key) {
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        GetRemainingLeaseTimeOperation operation = new GetRemainingLeaseTimeOperation(this.namespace, key);
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)operation, partitionId).build();
            Future future = invocation.invoke();
            return ((Number)future.get()).longValue();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public void lock(NodeEngine nodeEngine, Data key) {
        this.lock(nodeEngine, key, -1L);
    }

    public void lock(NodeEngine nodeEngine, Data key, long ttl) {
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        LockOperation operation = new LockOperation(this.namespace, key, ThreadUtil.getThreadId(), ttl, -1L);
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)operation, partitionId).build();
            Future future = invocation.invoke();
            Boolean result = (Boolean)future.get();
            if (!result.booleanValue()) {
                throw new IllegalStateException();
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public boolean tryLock(NodeEngine nodeEngine, Data key) {
        try {
            return this.tryLock(nodeEngine, key, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(NodeEngine nodeEngine, Data key, long timeout, TimeUnit timeunit) throws InterruptedException {
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        LockOperation operation = new LockOperation(this.namespace, key, ThreadUtil.getThreadId(), this.getTimeInMillis(timeout, timeunit));
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)operation, partitionId).build();
            Future future = invocation.invoke();
            return (Boolean)future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowInterrupted(t);
        }
    }

    private long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    public void unlock(NodeEngine nodeEngine, Data key) {
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        UnlockOperation operation = new UnlockOperation(this.namespace, key, ThreadUtil.getThreadId());
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)operation, partitionId).build();
            Future future = invocation.invoke();
            future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public void forceUnlock(NodeEngine nodeEngine, Data key) {
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        UnlockOperation operation = new UnlockOperation(this.namespace, key, -1, true);
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)operation, partitionId).build();
            Future future = invocation.invoke();
            future.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public ObjectNamespace getNamespace() {
        return this.namespace;
    }
}

