/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.out;

import pl.mn.communicator.User;
import pl.mn.communicator.packet.GGConversion;
import pl.mn.communicator.packet.GGUser;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.out.GGOutgoingPackage;

public class GGRemoveNotify
implements GGOutgoingPackage,
GGUser {
    public static final int GG_REMOVE_NOTIFY = 14;
    private int m_uin = -1;
    private User.UserMode m_userMode = null;
    private byte m_userType = 1;

    public GGRemoveNotify(int uin, User.UserMode userMode) {
        if (uin < 0) {
            throw new IllegalArgumentException("uin cannot be less than 0");
        }
        if (userMode == null) {
            throw new NullPointerException("userMode cannot be null");
        }
        this.m_uin = uin;
        this.m_userType = GGConversion.getProtocolUserMode(userMode);
    }

    public int getUin() {
        return this.m_uin;
    }

    public User.UserMode getUserMode() {
        return this.m_userMode;
    }

    public int getPacketType() {
        return 14;
    }

    public int getLength() {
        return 5;
    }

    public byte[] getContents() {
        byte[] dane = new byte[this.getLength()];
        byte[] uin = GGUtils.intToByte(this.m_uin);
        System.arraycopy(uin, 0, dane, 0, uin.length);
        dane[4] = this.m_userType;
        return dane;
    }
}

