/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import redstone.xmlrpc.XmlRpcArray;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcMessages;
import redstone.xmlrpc.XmlRpcStruct;
import redstone.xmlrpc.util.Base64;

public class XmlRpcValue {
    Object value;
    int type = -891985903;
    String memberName;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

    XmlRpcValue() {
    }

    void setType(int n) {
        this.type = n;
        if (n == 93090393) {
            this.value = new XmlRpcArray();
        } else if (n == -891974699) {
            this.value = new XmlRpcStruct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void processCharacterData(String string) throws XmlRpcException {
        switch (this.type) {
            case -891985903: {
                this.value = string;
                return;
            }
            case 3307: 
            case 104431: {
                this.value = new Integer(string);
                return;
            }
            case 64711720: {
                this.value = new Boolean(Integer.parseInt(string) == 1);
                return;
            }
            case -1325958191: {
                this.value = new Double(string);
                return;
            }
            case -586971087: {
                try {
                    SimpleDateFormat simpleDateFormat = dateFormatter;
                    synchronized (simpleDateFormat) {
                        this.value = dateFormatter.parse(string);
                        return;
                    }
                }
                catch (ParseException parseException) {
                    throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcValue.IllegalDate") + string, parseException);
                }
            }
            case -1396204209: {
                this.value = Base64.decode(string.getBytes());
                return;
            }
            case -891974699: {
                this.memberName = string;
            }
        }
    }

    void addChildValue(XmlRpcValue xmlRpcValue) {
        if (this.type == 93090393) {
            ((XmlRpcArray)this.value).add(xmlRpcValue.value);
        } else if (this.type == -891974699) {
            ((XmlRpcStruct)this.value).put(this.memberName, xmlRpcValue.value);
        } else {
            throw new XmlRpcException(XmlRpcMessages.getString("XmlRpcValue.UnexpectedNestedValue"));
        }
    }

    public int hashCode() {
        return this.type;
    }
}

