/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.sdp.Attribute;
import org.ice4j.ice.Agent;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.NominationStrategy;
import org.ice4j.ice.harvest.CandidateHarvester;
import org.ice4j.ice.harvest.TrickleCallback;
import org.ice4j.ice.sdp.IceSdpUtils;
import test.Ice;
import test.SdpUtils;

public class TrickleIce
extends Ice {
    private static final Logger logger = Logger.getLogger(TrickleIce.class.getName());

    public static void main(String[] args) throws Throwable {
        Agent localAgent = TrickleIce.createAgent(2020, true);
        localAgent.setNominationStrategy(NominationStrategy.NOMINATE_HIGHEST_PRIO);
        localAgent.addStateChangeListener(new Ice.IceProcessingListener());
        localAgent.setControlling(false);
        String localSDP = SdpUtils.createSDPDescription(localAgent);
        Thread.sleep(500L);
        logger.info("=================== feed the following to the remote agent ===================");
        logger.info("\n" + localSDP);
        logger.info("==============================================================================\n");
        CandidatePrinter printer = new CandidatePrinter();
        printer.agent = localAgent;
        localAgent.startCandidateTrickle(printer);
        LinkedList<Component> allComponents = new LinkedList<Component>();
        int allCandidates = 0;
        for (IceMediaStream stream : localAgent.getStreams()) {
            for (Component component : stream.getComponents()) {
                allComponents.add(component);
                allCandidates += component.getLocalCandidateCount();
            }
        }
        logger.info("all candidates = " + allCandidates);
        Thread.sleep(60000L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CandidatePrinter
    implements TrickleCallback {
        static int candidateCounter = 0;
        Agent agent;

        CandidatePrinter() {
        }

        @Override
        public void onIceCandidates(Collection<LocalCandidate> iceCandidates) {
            if (iceCandidates != null) {
                ++candidateCounter;
            }
            Collection<Attribute> update = IceSdpUtils.createTrickleUpdate(iceCandidates);
            for (Attribute attribute : update) {
                logger.info(attribute.toString().trim());
            }
            if (iceCandidates == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                logger.info("ICE stats: time=" + this.agent.getTotalHarvestingTime() + "ms");
                for (CandidateHarvester harvester : this.agent.getHarvesters()) {
                    logger.info(harvester.getHarvestStatistics().toString().trim());
                }
            }
        }
    }
}

