/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.attribute;

import java.util.Arrays;
import junit.framework.TestCase;
import org.ice4j.MsgFixture;
import org.ice4j.StunException;
import org.ice4j.attribute.NonceAttribute;

public class NonceAttributeTest
extends TestCase {
    private NonceAttribute nonceAttribute = null;
    MsgFixture msgFixture = null;
    String nonceValue = "0123456789abcdef";
    byte[] attributeBinValue = new byte[]{0, 21, 0, (byte)this.nonceValue.length(), 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    protected void setUp() throws Exception {
        super.setUp();
        this.msgFixture = new MsgFixture();
        this.nonceAttribute = new NonceAttribute();
        this.nonceAttribute.setNonce(this.nonceValue.getBytes());
        this.msgFixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.nonceAttribute = null;
        this.msgFixture.tearDown();
        this.msgFixture = null;
        super.tearDown();
    }

    public void testDecodeAttributeBody() throws StunException {
        char offset = '\u0000';
        NonceAttribute decoded = new NonceAttribute();
        char length = (char)this.nonceValue.length();
        decoded.decodeAttributeBody(this.nonceValue.getBytes(), offset, length);
        NonceAttributeTest.assertEquals((String)"decode failed", (Object)this.nonceAttribute, (Object)decoded);
    }

    public void testEncode() {
        NonceAttributeTest.assertTrue((String)"encode failed", (boolean)Arrays.equals(this.nonceAttribute.encode(), this.attributeBinValue));
    }

    public void testEquals() {
        NonceAttribute nonceAttribute2 = new NonceAttribute();
        nonceAttribute2.setNonce(this.nonceValue.getBytes());
        NonceAttributeTest.assertEquals((String)"testequals failed", (Object)this.nonceAttribute, (Object)nonceAttribute2);
        nonceAttribute2 = new NonceAttribute();
        nonceAttribute2.setNonce("some other nonce".getBytes());
        NonceAttributeTest.assertFalse((String)"testequals failed", (boolean)this.nonceAttribute.equals(nonceAttribute2));
        NonceAttributeTest.assertFalse((String)"testequals failed", (boolean)this.nonceAttribute.equals(null));
    }

    public void testGetDataLength() {
        char expectedReturn = (char)this.nonceValue.length();
        char actualReturn = this.nonceAttribute.getDataLength();
        NonceAttributeTest.assertEquals((String)"getDataLength - failed", (char)expectedReturn, (char)actualReturn);
    }

    public void testGetName() {
        String expectedReturn = "NONCE";
        String actualReturn = this.nonceAttribute.getName();
        NonceAttributeTest.assertEquals((String)"getting name failed", (String)expectedReturn, (String)actualReturn);
    }

    public void testSetGetNonce() {
        byte[] expectedReturn = this.nonceValue.getBytes();
        NonceAttribute att = new NonceAttribute();
        att.setNonce(expectedReturn);
        byte[] actualReturn = att.getNonce();
        NonceAttributeTest.assertTrue((String)"nonce setter or getter failed", (boolean)Arrays.equals(expectedReturn, actualReturn));
    }
}

