/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.dns;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.java.sip.communicator.impl.dns.DnsUtilActivator;
import net.java.sip.communicator.impl.dns.SecureMessage;
import net.java.sip.communicator.impl.dns.SecureResolveMode;
import net.java.sip.communicator.impl.dns.UnboundResolver;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.dns.DnssecRuntimeException;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.StringUtils;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.Type;

public class ConfigurableDnssecResolver
extends UnboundResolver {
    private static final Logger logger = Logger.getLogger(ConfigurableDnssecResolver.class);
    public static final String PNAME_DNSSEC_VALIDATION_MODE = "net.java.sip.communicator.util.dns.DNSSEC_VALIDATION_MODE";
    public static final String PNAME_BASE_DNSSEC_PIN = "net.java.sip.communicator.util.dns.pin";
    static final String EVENT_TYPE = "DNSSEC_NOTIFICATION";
    private ConfigurationService config = DnsUtilActivator.getConfigurationService();
    private ResourceManagementService R = DnsUtilActivator.getResources();
    private Map<String, Date> lastNotifications = new HashMap<String, Date>();

    public ConfigurableDnssecResolver() {
        this.reset();
        Lookup.setDefaultResolver((Resolver)this);
        DnsUtilActivator.getNotificationService().registerDefaultNotificationForEvent(EVENT_TYPE, "PopupMessageAction", null, null);
    }

    @Override
    protected void validateMessage(SecureMessage msg) throws DnssecRuntimeException {
        SecureResolveMode defaultAction;
        String type;
        String fqdn = msg.getQuestion().getName().toString();
        String propName = this.createPropNameUnsigned(fqdn, type = Type.string((int)msg.getQuestion().getType()));
        SecureResolveMode pinned = Enum.valueOf(SecureResolveMode.class, this.config.getString(propName, (defaultAction = Enum.valueOf(SecureResolveMode.class, this.config.getString(PNAME_DNSSEC_VALIDATION_MODE, SecureResolveMode.WarnIfBogus.name()))).name()));
        if (pinned == defaultAction) {
            this.config.setProperty(propName, (Object)pinned.name());
        }
        if (pinned == SecureResolveMode.IgnoreDnssec || msg.isSecure()) {
            return;
        }
        if (pinned == SecureResolveMode.SecureOnly && !msg.isSecure() || pinned == SecureResolveMode.SecureOrUnsigned && msg.isBogus()) {
            String text = this.getExceptionMessage(msg);
            Date last = this.lastNotifications.get(text);
            if (last == null || last.before(new Date(new Date().getTime() - 300000L))) {
                DnsUtilActivator.getNotificationService().fireNotification(EVENT_TYPE, this.R.getI18NString("util.dns.INSECURE_ANSWER_TITLE"), text, null);
                this.lastNotifications.put(text, new Date());
            }
            throw new DnssecRuntimeException(text);
        }
        if (pinned == SecureResolveMode.SecureOrUnsigned && !msg.isBogus()) {
            return;
        }
        if (pinned == SecureResolveMode.WarnIfBogus && !msg.isBogus()) {
            return;
        }
        String reason = msg.isBogus() ? this.R.getI18NString("util.dns.DNSSEC_ADVANCED_REASON_BOGUS", new String[]{fqdn, msg.getBogusReason()}) : this.R.getI18NString("util.dns.DNSSEC_ADVANCED_REASON_UNSIGNED", new String[]{type, fqdn});
        DnssecDialog dlg = new DnssecDialog(fqdn, reason);
        dlg.setVisible(true);
        DnssecDialogResult result = dlg.getResult();
        switch (result) {
            case Accept: {
                break;
            }
            case Deny: {
                throw new DnssecRuntimeException(this.getExceptionMessage(msg));
            }
            case AlwaysAccept: {
                if (msg.isBogus()) {
                    this.config.setProperty(propName, (Object)SecureResolveMode.IgnoreDnssec.name());
                    break;
                }
                this.config.setProperty(propName, (Object)SecureResolveMode.WarnIfBogus.name());
                break;
            }
            case AlwaysDeny: {
                this.config.setProperty(propName, (Object)SecureResolveMode.SecureOnly);
                throw new DnssecRuntimeException(this.getExceptionMessage(msg));
            }
        }
    }

    private String getExceptionMessage(SecureMessage msg) {
        return msg.getBogusReason() == null ? this.R.getI18NString("util.dns.INSECURE_ANSWER_MESSAGE_NO_REASON", new String[]{msg.getQuestion().getName().toString()}) : this.R.getI18NString("util.dns.INSECURE_ANSWER_MESSAGE_REASON", new String[]{msg.getQuestion().getName().toString(), msg.getBogusReason()});
    }

    private String createPropNameUnsigned(String fqdn, String type) {
        return "net.java.sip.communicator.util.dns.pin." + fqdn.replace(".", "__");
    }

    @Override
    public void reset() {
        String anchor;
        String forwarders = DnsUtilActivator.getConfigurationService().getString("net.java.sip.communicator.util.dns.DNSSEC_NAMESERVERS");
        if (!StringUtils.isNullOrEmpty((String)forwarders, (boolean)true)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Setting DNSSEC forwarders to: " + Arrays.toString(forwarders.split(","))));
            }
            super.setForwarders(forwarders.split(","));
        }
        int i = 1;
        while ((anchor = DnsUtilActivator.getResources().getSettingsString("net.java.sip.communicator.util.dns.DS_ROOT." + i)) != null) {
            this.clearTrustAnchors();
            this.addTrustAnchor(anchor);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Loaded trust anchor " + anchor));
            }
            ++i;
        }
    }

    private class DnssecDialog
    extends SIPCommDialog
    implements ActionListener {
        private static final long serialVersionUID = 0L;
        private JPanel pnlAdvanced;
        private JPanel pnlStandard;
        private final String domain;
        private final String reason;
        private JButton cmdAck;
        private JButton cmdShowDetails;
        private DnssecDialogResult result;

        public DnssecDialog(String domain, String reason) {
            super(false);
            this.result = DnssecDialogResult.Deny;
            this.setModal(true);
            this.domain = domain;
            this.reason = reason;
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout(15, 15));
            this.setTitle(ConfigurableDnssecResolver.this.R.getI18NString("util.dns.INSECURE_ANSWER_TITLE"));
            JLabel imgWarning = new JLabel(ConfigurableDnssecResolver.this.R.getImage("service.gui.icons.WARNING_ICON"));
            imgWarning.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add(imgWarning, "West");
            JLabel lblWarning = new JLabel(ConfigurableDnssecResolver.this.R.getI18NString("util.dns.DNSSEC_WARNING", new String[]{ConfigurableDnssecResolver.this.R.getSettingsString("service.gui.APPLICATION_NAME"), this.domain}));
            this.add(lblWarning, "Center");
            this.cmdAck = new JButton(ConfigurableDnssecResolver.this.R.getI18NString("service.gui.OK"));
            this.cmdAck.addActionListener(this);
            this.cmdShowDetails = new JButton(ConfigurableDnssecResolver.this.R.getI18NString("util.dns.DNSSEC_ADVANCED_OPTIONS"));
            this.cmdShowDetails.addActionListener(this);
            this.pnlStandard = new TransparentPanel((LayoutManager)new BorderLayout());
            this.pnlStandard.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.pnlStandard.add((Component)this.cmdShowDetails, "West");
            this.pnlStandard.add((Component)this.cmdAck, "East");
            this.add(this.pnlStandard, "South");
            this.pnlAdvanced = new TransparentPanel((LayoutManager)new BorderLayout());
            TransparentPanel pnlAdvancedButtons = new TransparentPanel((LayoutManager)new FlowLayout(2));
            pnlAdvancedButtons.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.pnlAdvanced.add((Component)pnlAdvancedButtons, "East");
            for (DnssecDialogResult r : DnssecDialogResult.values()) {
                JButton cmd = new JButton(ConfigurableDnssecResolver.this.R.getI18NString("net.java.sip.communicator.util.dns.ConfigurableDnssecResolver$DnssecDialogResult." + r.name()));
                cmd.setActionCommand(r.name());
                cmd.addActionListener(this);
                pnlAdvancedButtons.add(cmd);
            }
            JLabel lblReason = new JLabel(this.reason);
            lblReason.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.pnlAdvanced.add((Component)lblReason, "North");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cmdAck) {
                this.result = DnssecDialogResult.Deny;
                this.dispose();
            } else if (e.getSource() == this.cmdShowDetails) {
                this.getContentPane().remove(this.pnlStandard);
                this.add(this.pnlAdvanced, "South");
                this.pack();
            } else {
                this.result = Enum.valueOf(DnssecDialogResult.class, e.getActionCommand());
                this.dispose();
            }
        }

        public DnssecDialogResult getResult() {
            return this.result;
        }
    }

    private static enum DnssecDialogResult {
        Accept,
        Deny,
        AlwaysAccept,
        AlwaysDeny;

    }
}

