/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp.util;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.RTPPushDataSource;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketSource;
import net.sf.fmj.media.rtp.util.UDPPacket;

public class RTPPacketReceiver
implements PacketSource,
SourceTransferHandler {
    RTPPushDataSource rtpsource = null;
    CircularBuffer bufQue = new CircularBuffer(2);
    boolean closed = false;
    boolean dataRead = false;

    public RTPPacketReceiver(PushSourceStream pss) {
        pss.setTransferHandler(this);
    }

    public RTPPacketReceiver(RTPPushDataSource rtpsource) {
        this.rtpsource = rtpsource;
        PushSourceStream output = rtpsource.getOutputStream();
        output.setTransferHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSource() {
        CircularBuffer circularBuffer = this.bufQue;
        synchronized (circularBuffer) {
            this.closed = true;
            this.bufQue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet receiveFrom() throws IOException {
        Buffer buf;
        CircularBuffer circularBuffer = this.bufQue;
        synchronized (circularBuffer) {
            if (this.dataRead) {
                this.bufQue.readReport();
                this.bufQue.notify();
            }
            while (!this.bufQue.canRead() && !this.closed) {
                try {
                    this.bufQue.wait(1000L);
                }
                catch (InterruptedException e) {}
            }
            if (this.closed) {
                buf = null;
                this.dataRead = false;
            } else {
                buf = this.bufQue.read();
                this.dataRead = true;
            }
        }
        byte[] data = buf != null ? (byte[])buf.getData() : new byte[1];
        UDPPacket p = new UDPPacket();
        p.receiptTime = System.currentTimeMillis();
        p.data = data;
        p.offset = 0;
        p.length = buf != null ? buf.getLength() : 0;
        return p;
    }

    public String sourceString() {
        String s = "RTPPacketReceiver for " + this.rtpsource;
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferData(PushSourceStream sourcestream) {
        Buffer buf;
        CircularBuffer circularBuffer = this.bufQue;
        synchronized (circularBuffer) {
            while (!this.bufQue.canWrite() && !this.closed) {
                try {
                    this.bufQue.wait(1000L);
                }
                catch (InterruptedException e) {}
            }
            if (this.closed) {
                return;
            }
            buf = this.bufQue.getEmptyBuffer();
        }
        int size = sourcestream.getMinimumTransferSize();
        byte[] data = (byte[])buf.getData();
        int len = 0;
        if (data == null || data.length < size) {
            data = new byte[size];
            buf.setData(data);
        }
        try {
            len = sourcestream.read(data, 0, size);
        }
        catch (IOException e) {
            // empty catch block
        }
        buf.setLength(len);
        buf.setOffset(0);
        CircularBuffer circularBuffer2 = this.bufQue;
        synchronized (circularBuffer2) {
            this.bufQue.writeReport();
            this.bufQue.notify();
        }
    }
}

