/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.parser;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import net.sf.fmj.media.AbstractDemultiplexer;
import net.sf.fmj.media.AbstractTrack;
import net.sf.fmj.media.PullSourceStreamInputStream;
import net.sf.fmj.media.parser.XmlMovieSAXHandler;
import net.sf.fmj.media.parser.XmlMovieSAXParserThread;
import net.sf.fmj.utility.LoggerSingleton;
import org.xml.sax.SAXException;

public class XmlMovieParser
extends AbstractDemultiplexer {
    private static final Logger logger = LoggerSingleton.logger;
    private ContentDescriptor[] supportedInputContentDescriptors = new ContentDescriptor[]{new ContentDescriptor("video.xml")};
    private PullDataSource source;
    private PullSourceStreamTrack[] tracks;
    private XmlMovieSAXHandler xmlMovieSAXHandler;
    private XmlMovieSAXParserThread xmlMovieSAXParserThread;

    public void close() {
        if (this.tracks != null) {
            for (int i = 0; i < this.tracks.length; ++i) {
                if (this.tracks[i] == null) continue;
                this.tracks[i].deallocate();
                this.tracks[i] = null;
            }
            this.tracks = null;
        }
        super.close();
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return this.supportedInputContentDescriptors;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        return this.tracks;
    }

    public boolean isPositionable() {
        return false;
    }

    public boolean isRandomAccess() {
        return super.isRandomAccess();
    }

    public void open() throws ResourceUnavailableException {
        try {
            this.source.start();
            PullSourceStream[] streams = this.source.getStreams();
            if (streams.length > 1) {
                logger.warning("only 1 stream supported, " + streams.length + " found");
            }
            PullSourceStreamInputStream is = new PullSourceStreamInputStream(streams[0]);
            this.xmlMovieSAXHandler = new XmlMovieSAXHandler();
            this.xmlMovieSAXParserThread = new XmlMovieSAXParserThread(this.xmlMovieSAXHandler, is);
            this.xmlMovieSAXParserThread.start();
            Format[] formats = this.xmlMovieSAXHandler.readTracksInfo();
            this.tracks = new PullSourceStreamTrack[formats.length];
            for (int i = 0; i < formats.length; ++i) {
                this.tracks[i] = new VideoTrack(i, formats[i]);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new ResourceUnavailableException("" + e);
        }
        catch (SAXException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new ResourceUnavailableException("" + e);
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw new ResourceUnavailableException("" + e);
        }
        super.open();
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        String protocol = source.getLocator().getProtocol();
        if (!(source instanceof PullDataSource)) {
            throw new IncompatibleSourceException();
        }
        this.source = (PullDataSource)source;
    }

    public void start() throws IOException {
    }

    private class VideoTrack
    extends PullSourceStreamTrack {
        private final int track;
        private final Format format;

        public VideoTrack(int track, Format format) throws ResourceUnavailableException {
            this.track = track;
            this.format = format;
        }

        public boolean canSkipNanos() {
            return false;
        }

        public void deallocate() {
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }

        public Format getFormat() {
            return this.format;
        }

        public Time mapFrameToTime(int frameNumber) {
            return TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time t) {
            return Integer.MAX_VALUE;
        }

        public void readFrame(Buffer buffer) {
            Buffer b;
            try {
                b = XmlMovieParser.this.xmlMovieSAXHandler.readBuffer(this.track);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            buffer.copy(b);
        }

        public long skipNanos(long nanos) throws IOException {
            return 0L;
        }
    }

    private abstract class PullSourceStreamTrack
    extends AbstractTrack {
        private PullSourceStreamTrack() {
        }

        public abstract void deallocate();
    }
}

