/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.GroupChatInvitation;
import org.jivesoftware.smackx.bytestreams.ibb.provider.CloseIQProvider;
import org.jivesoftware.smackx.bytestreams.ibb.provider.DataPacketProvider;
import org.jivesoftware.smackx.bytestreams.ibb.provider.OpenIQProvider;
import org.jivesoftware.smackx.bytestreams.socks5.provider.BytestreamsProvider;
import org.jivesoftware.smackx.packet.ChatStateExtension;
import org.jivesoftware.smackx.packet.LastActivity;
import org.jivesoftware.smackx.packet.OfflineMessageInfo;
import org.jivesoftware.smackx.packet.OfflineMessageRequest;
import org.jivesoftware.smackx.packet.Version;
import org.jivesoftware.smackx.provider.DataFormProvider;
import org.jivesoftware.smackx.provider.DelayInfoProvider;
import org.jivesoftware.smackx.provider.DelayInformationProvider;
import org.jivesoftware.smackx.provider.DiscoverInfoProvider;
import org.jivesoftware.smackx.provider.DiscoverItemsProvider;
import org.jivesoftware.smackx.provider.MUCAdminProvider;
import org.jivesoftware.smackx.provider.MUCOwnerProvider;
import org.jivesoftware.smackx.provider.MUCUserProvider;
import org.jivesoftware.smackx.provider.MessageEventProvider;
import org.jivesoftware.smackx.provider.RosterExchangeProvider;
import org.jivesoftware.smackx.provider.StreamInitiationProvider;
import org.jivesoftware.smackx.provider.VCardProvider;
import org.jivesoftware.smackx.provider.XHTMLExtensionProvider;

public class ProviderManagerExt
extends ProviderManager {
    private static final Logger logger = Logger.getLogger(ProviderManagerExt.class);

    ProviderManagerExt() {
        this.load();
    }

    public void load() {
        this.addExtProvider("x", "jabber:x:roster", RosterExchangeProvider.class);
        this.addExtProvider("x", "jabber:x:event", MessageEventProvider.class);
        this.addExtProvider("active", "http://jabber.org/protocol/chatstates", ChatStateExtension.Provider.class);
        this.addExtProvider("composing", "http://jabber.org/protocol/chatstates", ChatStateExtension.Provider.class);
        this.addExtProvider("paused", "http://jabber.org/protocol/chatstates", ChatStateExtension.Provider.class);
        this.addExtProvider("inactive", "http://jabber.org/protocol/chatstates", ChatStateExtension.Provider.class);
        this.addExtProvider("gone", "http://jabber.org/protocol/chatstates", ChatStateExtension.Provider.class);
        this.addExtProvider("html", "http://jabber.org/protocol/xhtml-im", XHTMLExtensionProvider.class);
        this.addExtProvider("x", "jabber:x:conference", GroupChatInvitation.Provider.class);
        this.addProvider("query", "http://jabber.org/protocol/disco#items", DiscoverItemsProvider.class);
        this.addProvider("query", "http://jabber.org/protocol/disco#info", DiscoverInfoProvider.class);
        this.addExtProvider("x", "jabber:x:data", DataFormProvider.class);
        this.addExtProvider("x", "http://jabber.org/protocol/muc#user", MUCUserProvider.class);
        this.addProvider("query", "http://jabber.org/protocol/muc#admin", MUCAdminProvider.class);
        this.addProvider("query", "http://jabber.org/protocol/muc#owner", MUCOwnerProvider.class);
        this.addExtProvider("x", "jabber:x:delay", DelayInformationProvider.class);
        this.addExtProvider("delay", "urn:xmpp:delay", DelayInfoProvider.class);
        this.addProvider("query", "jabber:iq:version", Version.class);
        this.addProvider("vCard", "vcard-temp", VCardProvider.class);
        this.addProvider("offline", "http://jabber.org/protocol/offline", OfflineMessageRequest.Provider.class);
        this.addExtProvider("offline", "http://jabber.org/protocol/offline", OfflineMessageInfo.Provider.class);
        this.addProvider("query", "jabber:iq:last", LastActivity.class);
        this.addProvider("si", "http://jabber.org/protocol/si", StreamInitiationProvider.class);
        this.addProvider("query", "http://jabber.org/protocol/bytestreams", BytestreamsProvider.class);
        this.addProvider("open", "http://jabber.org/protocol/ibb", OpenIQProvider.class);
        this.addProvider("data", "http://jabber.org/protocol/ibb", DataPacketProvider.class);
        this.addProvider("close", "http://jabber.org/protocol/ibb", CloseIQProvider.class);
        this.addExtProvider("data", "http://jabber.org/protocol/ibb", DataPacketProvider.class);
    }

    private void addProvider(String elementName, String namespace, Class<?> provider) {
        try {
            if (IQProvider.class.isAssignableFrom(provider)) {
                this.addIQProvider(elementName, namespace, provider.newInstance());
            } else if (IQ.class.isAssignableFrom(provider)) {
                this.addIQProvider(elementName, namespace, provider);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error adding iq provider.", t);
        }
    }

    public void addExtProvider(String elementName, String namespace, Class<?> provider) {
        try {
            if (PacketExtensionProvider.class.isAssignableFrom(provider)) {
                this.addExtensionProvider(elementName, namespace, provider.newInstance());
            } else if (PacketExtension.class.isAssignableFrom(provider)) {
                this.addExtensionProvider(elementName, namespace, provider);
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error adding extension provider.", t);
        }
    }
}

