/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.auth.AuthCommand;
import net.kano.joscar.snaccmd.auth.ClientVersionInfo;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class AuthRequest
extends AuthCommand {
    private static final int TYPE_SN = 1;
    private static final int TYPE_COUNTRY = 14;
    private static final int TYPE_LANG = 15;
    private static final int TYPE_ENCPASS = 37;
    private static final int TYPE_HASHEDPASS = 76;
    private static final byte[] AIMSM_BYTES;
    private final String sn;
    private final ClientVersionInfo version;
    private final Locale locale;
    private final ByteBlock encryptedPass;
    private final boolean hashedPass;

    private static byte[] encryptPassword(String string, ByteBlock byteBlock, boolean bl) {
        byte[] byArray;
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        if (bl) {
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return null;
            }
            byArray = messageDigest.digest(byArray);
        }
        return AuthRequest.getPassHash(byteBlock, ByteBlock.wrap(byArray));
    }

    private static byte[] getPassHash(ByteBlock byteBlock, ByteBlock byteBlock2) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        messageDigest.update(byteBlock.toByteArray());
        messageDigest.update(byteBlock2.toByteArray());
        messageDigest.update(AIMSM_BYTES);
        return messageDigest.digest();
    }

    protected AuthRequest(SnacPacket snacPacket) {
        super(2);
        DefensiveTools.checkNull(snacPacket, "packet");
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(snacPacket.getData());
        this.sn = immutableTlvChain.getString(1);
        this.encryptedPass = immutableTlvChain.hasTlv(37) ? immutableTlvChain.getLastTlv(37).getData() : null;
        this.version = ClientVersionInfo.readClientVersionInfo(immutableTlvChain);
        String string = immutableTlvChain.getString(15);
        String string2 = immutableTlvChain.getString(14);
        this.locale = string != null && string2 != null ? new Locale(string, string2) : null;
        this.hashedPass = immutableTlvChain.hasTlv(76);
    }

    public AuthRequest(String string, String string2, ClientVersionInfo clientVersionInfo, ByteBlock byteBlock) {
        this(string, string2, clientVersionInfo, Locale.getDefault(), byteBlock);
    }

    public AuthRequest(String string, String string2, ClientVersionInfo clientVersionInfo, Locale locale, ByteBlock byteBlock) {
        super(2);
        this.sn = string;
        this.version = clientVersionInfo;
        this.locale = locale;
        this.hashedPass = true;
        this.encryptedPass = ByteBlock.wrap(AuthRequest.encryptPassword(string2, byteBlock, true));
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final ClientVersionInfo getVersionInfo() {
        return this.version;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final ByteBlock getEncryptedPass() {
        return this.encryptedPass;
    }

    public final boolean isPassHashed() {
        return this.hashedPass;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.sn != null) {
            Tlv.getStringInstance(1, this.sn).write(outputStream);
        }
        if (this.encryptedPass != null) {
            new Tlv(37, this.encryptedPass).write(outputStream);
        }
        if (this.hashedPass) {
            new Tlv(76).write(outputStream);
        }
        Tlv.getUShortInstance(22, 265).write(outputStream);
        if (this.version != null) {
            this.version.write(outputStream);
        }
        if (this.locale != null) {
            String string;
            String string2 = this.locale.getCountry();
            if (!string2.equals("")) {
                Tlv.getStringInstance(14, string2).write(outputStream);
            }
            if (!(string = this.locale.getLanguage()).equals("")) {
                Tlv.getStringInstance(15, string).write(outputStream);
            }
        }
        new Tlv(74, ByteBlock.wrap(new byte[]{1})).write(outputStream);
    }

    public String toString() {
        return "AuthRequest: sn='" + this.sn + "'" + ", version='" + this.version + "'" + ", locale=" + this.locale;
    }

    static {
        byte[] byArray = null;
        try {
            byArray = "AOL Instant Messenger (SM)".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        AIMSM_BYTES = byArray;
    }
}

