/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.SingleBuddyRequest;
import net.kano.joscar.snaccmd.loc.LocCommand;

public class GetDirInfoCmd
extends LocCommand
implements SingleBuddyRequest {
    private final String sn;

    protected GetDirInfoCmd(SnacPacket packet) {
        super(11);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        StringBlock snData = OscarTools.readScreenname(snacData);
        this.sn = snData == null ? null : snData.getString();
    }

    public GetDirInfoCmd(String sn) {
        super(11);
        this.sn = sn;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.sn != null) {
            OscarTools.writeScreenname(out, this.sn);
        }
    }

    public String toString() {
        return "GetDirInfoCmd for " + this.sn;
    }
}

