/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.tlv;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.tlv.AbstractTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMutableTlvChain
extends AbstractTlvChain
implements MutableTlvChain {
    private final List<Tlv> tlvList = new LinkedList<Tlv>();
    private final Map<Integer, List<Tlv>> tlvMap = new HashMap<Integer, List<Tlv>>();

    protected DefaultMutableTlvChain() {
    }

    protected DefaultMutableTlvChain(TlvChain other) {
        this.copy(other);
    }

    @Override
    public final synchronized void addTlv(Tlv tlv) {
        this.addTlvImpl(tlv);
    }

    @Override
    public final synchronized void replaceTlv(Tlv tlv) {
        DefensiveTools.checkNull((Object)tlv, (String)"tlv");
        int typeCode = tlv.getType();
        List<Tlv> tlvs = this.getTlvMap().get(typeCode);
        int insertAt = -1;
        if (tlvs == null) {
            tlvs = new LinkedList<Tlv>();
            this.getTlvMap().put(typeCode, tlvs);
        } else if (!tlvs.isEmpty()) {
            int i = 0;
            Iterator<Tlv> it = this.getTlvList().iterator();
            while (it.hasNext()) {
                Tlv next = it.next();
                if (next.getType() == typeCode) {
                    if (insertAt == -1) {
                        insertAt = i;
                    }
                    it.remove();
                }
                ++i;
            }
            tlvs.clear();
        }
        if (insertAt == -1) {
            insertAt = this.getTlvList().size();
        }
        tlvs.add(tlv);
        this.getTlvList().add(insertAt, tlv);
    }

    @Override
    public final synchronized void removeTlv(Tlv tlv) {
        DefensiveTools.checkNull((Object)tlv, (String)"tlv");
        int typeCode = tlv.getType();
        List<Tlv> tlvs = this.getTlvMap().get(typeCode);
        if (tlvs != null) {
            while (tlvs.remove(tlv)) {
            }
        }
        while (this.getTlvList().remove(tlv)) {
        }
    }

    @Override
    public final synchronized void removeTlvs(int type) {
        DefensiveTools.checkRange((int)type, (String)"type", (int)0);
        List<Tlv> tlvs = this.getTlvMap().remove(type);
        if (tlvs != null) {
            this.getTlvList().removeAll(tlvs);
        }
    }

    @Override
    public final synchronized void removeTlvs(int ... types) {
        int[] safeTypes;
        DefensiveTools.checkNull((Object)types, (String)"types");
        for (int safeType : safeTypes = (int[])types.clone()) {
            DefensiveTools.checkRange((int)safeType, (String)"types[] elements", (int)0);
        }
        for (int safeType1 : safeTypes) {
            this.removeTlvs(safeType1);
        }
    }

    @Override
    public final synchronized void addAll(TlvChain other) {
        DefensiveTools.checkNull((Object)other, (String)"other");
        List<Tlv> tlvs = other instanceof AbstractTlvChain ? ((AbstractTlvChain)other).getTlvList() : other.getTlvs();
        for (Tlv tlv : tlvs) {
            this.addTlvImpl(tlv);
        }
    }

    @Override
    public final synchronized void replaceAll(TlvChain other) {
        DefensiveTools.checkNull((Object)other, (String)"other");
        List<Tlv> tlvs = other instanceof AbstractTlvChain ? ((AbstractTlvChain)other).getTlvList() : other.getTlvs();
        for (Tlv tlv : tlvs) {
            this.replaceTlv(tlv);
        }
    }

    @Override
    protected synchronized List<Tlv> getTlvList() {
        return this.tlvList;
    }

    @Override
    protected synchronized Map<Integer, List<Tlv>> getTlvMap() {
        return this.tlvMap;
    }
}

