/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.AbstractInfoCmd;

public class MetaEmailInfoCmd
extends AbstractInfoCmd {
    private String[] emails;
    private boolean[] emailsPublished;

    protected MetaEmailInfoCmd(SnacPacket packet) {
        super(packet);
    }

    protected MetaEmailInfoCmd(long uin, int id, String[] emails, boolean[] emailsPublished) {
        super(uin, AbstractIcqCmd.CMD_META_EMAIL_INFO_CMD, id);
        this.emails = emails;
        this.emailsPublished = emailsPublished;
    }

    protected void readInfo(InputStream is) throws IOException {
        int emailCount = is.read();
        if (emailCount > 0) {
            this.emails = new String[emailCount];
            this.emailsPublished = new boolean[emailCount];
            for (int i = 0; i < emailCount; ++i) {
                this.emailsPublished[i] = is.read() > 0;
                this.emails[i] = LEBinaryTools.readUShortLengthString(is, "US-ASCII");
            }
        }
    }

    protected void writeInfo(OutputStream out) throws IOException {
        int emailCount = this.emails == null ? 0 : this.emails.length;
        LEBinaryTools.writeUByte(out, emailCount);
        for (int i = 0; i < emailCount; ++i) {
            LEBinaryTools.writeUByte(out, this.emailsPublished[i] ? 1 : 0);
            LEBinaryTools.writeUShortLengthString(out, this.emails[i]);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("MetaEmailInfoCmd: emails={");
        if (this.emails != null) {
            for (int i = 0; i < this.emails.length; ++i) {
                if (i > 0) {
                    result.append(",");
                }
                result.append(this.emails[i]);
                result.append(this.emailsPublished[i] ? " (+)" : " (-)");
            }
        }
        result.append(" } in ").append(super.toString());
        return result.toString();
    }
}

