/*
 * Decompiled with CFR 0.152.
 */
package com.rayo.core.cdr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateFormatUtils;

public class Cdr
implements Serializable {
    private static final long serialVersionUID = -1948067531358803733L;
    private String callId;
    private long startTime;
    private long endTime;
    private String from;
    private String to;
    private String state;
    private List<String> transcript = new ArrayList<String>();

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public void add(String element) {
        this.transcript.add(this.timestamp(element));
    }

    public List<String> getTranscript() {
        return this.transcript;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setTranscript(List<String> transcript) {
        this.transcript = transcript;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(String.format("<cdr callId=\"%s\" from=\"%s\" to=\"%s\" start=\"%s\" end=\"%s\" state=\"%s\" xmlns=\"http://tropo.com/schema/cdr\"  xmlns:cdr=\"http://tropo.com/schema/cdr\">", this.getCallId(), this.getFrom(), this.getTo(), this.formatDate(new Date(this.getStartTime())), this.formatDate(new Date(this.getEndTime())), this.getState()));
        for (String element : this.getTranscript()) {
            builder.append(element);
        }
        builder.append("</cdr>\n");
        return builder.toString();
    }

    private String timestamp(String element) {
        StringBuffer builder;
        int i = element.indexOf(62);
        if (i == element.length() - 1) {
            --i;
        }
        if ((builder = new StringBuffer(element.substring(0, i))).charAt(builder.length() - 1) != ' ') {
            builder.append(' ');
        }
        builder.append(String.format("cdr:ts=\"%s\"", this.formatDate(new Date())));
        builder.append(element.substring(i));
        return builder.toString();
    }

    private String formatDate(Date date) {
        return DateFormatUtils.format((Date)new Date(), (String)"yyyy-dd-MM hh:mm:ss.SZ");
    }
}

