/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.utils.IFilter;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringIterator<E>
implements Iterator<E> {
    private IFilter<E> filter;
    private Iterator<E> it;
    private E next;

    public FilteringIterator(Iterator<E> it, IFilter<E> filter) {
        this.it = it;
        this.filter = filter;
    }

    public FilteringIterator(Iterator<E> it) {
        this(it, null);
    }

    @Override
    public final boolean hasNext() {
        return this.next != null || this.fetchNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E next() {
        if (this.next == null && !this.fetchNext()) {
            throw new IllegalStateException("Next element not available");
        }
        try {
            E e = this.next;
            return e;
        }
        finally {
            this.next = null;
        }
    }

    @Override
    public final void remove() {
        this.it.remove();
    }

    private boolean fetchNext() {
        Object item = null;
        while (this.it.hasNext() && !this.accept(item = this.it.next())) {
            item = null;
        }
        this.next = item;
        return this.next != null;
    }

    protected boolean accept(E item) {
        if (this.filter != null) {
            return this.filter.accept(item);
        }
        throw new IllegalStateException("Either provide a filter or override accept()");
    }
}

