/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.sentinel.local;

import com.voxeo.sentinel.local.LocalSentinel;
import com.voxeo.sentinel.protocols.LocalSentinelProtocol;
import com.voxeo.versioning.Module;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.net.Socket;
import org.apache.log4j.Logger;

public class LocalSentinelThread
extends Thread {
    private static final Logger Log = Logger.getLogger(LocalSentinelThread.class);
    private Socket socket = null;

    public LocalSentinelThread(Socket socket) {
        super("LocalSentinelThread");
        this.socket = socket;
    }

    public void run() {
        try {
            PrintWriter out;
            BufferedReader in;
            block5: {
                in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                out = new PrintWriter(this.socket.getOutputStream(), true);
                try {
                    new ObjectInputStream(this.socket.getInputStream());
                    LocalSentinelProtocol lsp = new LocalSentinelProtocol(in, out, this);
                    Log.debug((Object)"Server handling client...");
                    lsp.rcvModule();
                    this.unregisterModule(lsp);
                    Log.debug((Object)"Server done handling client, closing connections...");
                }
                catch (StreamCorruptedException e) {
                    String header = "";
                    char currentChar = '\u0000';
                    InputStream streamIn = this.socket.getInputStream();
                    while ((currentChar = (char)streamIn.read()) != '\uffffffff' && !(header = header + currentChar).endsWith("\r\n\r\n") && header.length() <= 1024) {
                    }
                    if (header.indexOf("HTTP") == -1 || !header.endsWith("\r\n\r\n") || header.length() >= 1024) break block5;
                    LocalSentinel.handleHTTPRequest(out, this.socket.getLocalAddress().getHostName(), this.socket.getLocalAddress().getHostAddress());
                }
            }
            out.close();
            in.close();
            this.socket.close();
        }
        catch (IOException e) {
            Log.debug((Object)"Error running local sentinel.", (Throwable)e);
        }
    }

    public boolean registerModule(Object incoming, LocalSentinelProtocol localSentinelProtocol) {
        boolean returnValue = false;
        if (incoming instanceof Module) {
            LocalSentinel.registerModule((Module)incoming, localSentinelProtocol);
            returnValue = true;
        }
        return returnValue;
    }

    public void unregisterModule(LocalSentinelProtocol localSentinelProtocol) {
        LocalSentinel.unregisterModule(localSentinelProtocol);
    }
}

