/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.MapReplicationOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReplicationInfo;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexInfo;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.MapIndexInfo;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.ServiceNamespace;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ThreadUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapReplicationStateHolder
implements IdentifiedDataSerializable,
Versioned {
    protected Map<String, Set<RecordReplicationInfo>> data;
    protected Map<String, Boolean> loaded;
    protected List<MapIndexInfo> mapIndexInfos;
    private MapReplicationOperation mapReplicationOperation;

    public MapReplicationStateHolder() {
    }

    public MapReplicationStateHolder(MapReplicationOperation mapReplicationOperation) {
        this.mapReplicationOperation = mapReplicationOperation;
    }

    void prepare(PartitionContainer container, Collection<ServiceNamespace> namespaces, int replicaIndex) {
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(namespaces.size());
        this.loaded = new HashMap<String, Boolean>(namespaces.size());
        this.mapIndexInfos = new ArrayList<MapIndexInfo>(namespaces.size());
        for (ServiceNamespace namespace : namespaces) {
            MapContainer mapContainer;
            MapConfig mapConfig;
            ObjectNamespace mapNamespace = (ObjectNamespace)namespace;
            String mapName = mapNamespace.getObjectName();
            RecordStore recordStore = container.getRecordStore(mapName);
            if (recordStore == null || (mapConfig = (mapContainer = recordStore.getMapContainer()).getMapConfig()).getTotalBackupCount() < replicaIndex) continue;
            MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
            this.loaded.put(mapName, recordStore.isLoaded());
            HashSet<RecordReplicationInfo> recordSet = new HashSet<RecordReplicationInfo>(recordStore.size());
            Iterator<Record> iterator = recordStore.iterator();
            while (iterator.hasNext()) {
                Record record = iterator.next();
                Index[] key = record.getKey();
                RecordReplicationInfo recordReplicationInfo = this.mapReplicationOperation.createRecordReplicationInfo((Data)key, record, mapServiceContext);
                recordSet.add(recordReplicationInfo);
            }
            this.data.put(mapName, recordSet);
            HashSet<IndexInfo> indexInfos = new HashSet<IndexInfo>();
            if (mapContainer.isGlobalIndexEnabled()) {
                for (Index index : mapContainer.getIndexes().getIndexes()) {
                    indexInfos.add(new IndexInfo(index.getAttributeName(), index.isOrdered()));
                }
            } else {
                Indexes indexes = mapContainer.getIndexes(container.getPartitionId());
                if (indexes != null && indexes.hasIndex()) {
                    for (Index index : indexes.getIndexes()) {
                        indexInfos.add(new IndexInfo(index.getAttributeName(), index.isOrdered()));
                    }
                }
            }
            MapIndexInfo mapIndexInfo = new MapIndexInfo(mapName);
            mapIndexInfo.addIndexInfos(indexInfos);
            this.mapIndexInfos.add(mapIndexInfo);
        }
    }

    void applyState() {
        ThreadUtil.assertRunningOnPartitionThread();
        if (this.mapIndexInfos != null) {
            for (MapIndexInfo mapIndexInfo : this.mapIndexInfos) {
                this.addIndexes(mapIndexInfo.getMapName(), mapIndexInfo.getIndexInfos());
            }
        }
        for (String string : this.data.keySet()) {
            RecordStore recordStore = this.mapReplicationOperation.getRecordStore(string);
            MapContainer mapContainer = recordStore.getMapContainer();
            this.addIndexes(string, mapContainer.getPartitionIndexesToAdd());
        }
        if (this.data != null) {
            for (Map.Entry entry : this.data.entrySet()) {
                Set recordReplicationInfos = (Set)entry.getValue();
                String mapName = (String)entry.getKey();
                RecordStore recordStore = this.mapReplicationOperation.getRecordStore(mapName);
                recordStore.reset();
                recordStore.setPreMigrationLoadedStatus(this.loaded.get(mapName));
                MapContainer mapContainer = recordStore.getMapContainer();
                PartitionContainer partitionContainer = recordStore.getMapContainer().getMapServiceContext().getPartitionContainer(this.mapReplicationOperation.getPartitionId());
                for (Map.Entry<String, Boolean> indexDefinition : mapContainer.getIndexDefinitions().entrySet()) {
                    Indexes indexes = mapContainer.getIndexes(partitionContainer.getPartitionId());
                    indexes.addOrGetIndex(indexDefinition.getKey(), indexDefinition.getValue());
                }
                for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                    Data key = recordReplicationInfo.getKey();
                    Data value = recordReplicationInfo.getValue();
                    Record newRecord = recordStore.createRecord(value, -1L, Clock.currentTimeMillis());
                    Records.applyRecordInfo(newRecord, recordReplicationInfo);
                    recordStore.putRecord(key, newRecord);
                }
            }
        }
    }

    private void addIndexes(String mapName, Collection<IndexInfo> indexInfos) {
        if (indexInfos == null) {
            return;
        }
        RecordStore recordStore = this.mapReplicationOperation.getRecordStore(mapName);
        MapContainer mapContainer = recordStore.getMapContainer();
        if (mapContainer.isGlobalIndexEnabled()) {
            for (IndexInfo indexInfo : indexInfos) {
                Indexes indexes = mapContainer.getIndexes();
                if (indexes.getIndex(indexInfo.getAttributeName()) != null) continue;
                indexes.addOrGetIndex(indexInfo.getAttributeName(), indexInfo.isOrdered());
            }
        } else {
            Indexes indexes = mapContainer.getIndexes(this.mapReplicationOperation.getPartitionId());
            for (IndexInfo indexInfo : indexInfos) {
                indexes.addOrGetIndex(indexInfo.getAttributeName(), indexInfo.isOrdered());
            }
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.data.size());
        for (Map.Entry<String, Set<RecordReplicationInfo>> entry : this.data.entrySet()) {
            out.writeUTF(entry.getKey());
            Set<RecordReplicationInfo> recordReplicationInfos = entry.getValue();
            out.writeInt(recordReplicationInfos.size());
            for (RecordReplicationInfo recordReplicationInfo : recordReplicationInfos) {
                out.writeObject(recordReplicationInfo);
            }
        }
        out.writeInt(this.loaded.size());
        for (Map.Entry<String, Object> entry : this.loaded.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeBoolean((Boolean)entry.getValue());
        }
        if (out.getVersion().isGreaterOrEqual(Versions.V3_9)) {
            out.writeInt(this.mapIndexInfos.size());
            for (MapIndexInfo mapIndexInfo : this.mapIndexInfos) {
                out.writeObject(mapIndexInfo);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.data = new HashMap<String, Set<RecordReplicationInfo>>(size);
        for (int i = 0; i < size; ++i) {
            String name = in.readUTF();
            int mapSize = in.readInt();
            HashSet<RecordReplicationInfo> recordReplicationInfos = new HashSet<RecordReplicationInfo>(mapSize);
            for (int j = 0; j < mapSize; ++j) {
                RecordReplicationInfo recordReplicationInfo = (RecordReplicationInfo)in.readObject();
                recordReplicationInfos.add(recordReplicationInfo);
            }
            this.data.put(name, recordReplicationInfos);
        }
        int loadedSize = in.readInt();
        this.loaded = new HashMap<String, Boolean>(loadedSize);
        for (int i = 0; i < loadedSize; ++i) {
            this.loaded.put(in.readUTF(), in.readBoolean());
        }
        if (in.getVersion().isGreaterOrEqual(Versions.V3_9)) {
            int mapIndexInfosSize = in.readInt();
            this.mapIndexInfos = new ArrayList<MapIndexInfo>(mapIndexInfosSize);
            for (int i = 0; i < mapIndexInfosSize; ++i) {
                MapIndexInfo mapIndexInfo = (MapIndexInfo)in.readObject();
                this.mapIndexInfos.add(mapIndexInfo);
            }
        } else {
            this.mapIndexInfos = null;
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 113;
    }
}

