/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembersViewMetadata;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.internal.cluster.impl.operations.VersionedClusterOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;

public class MasterConfirmationOp
extends AbstractClusterOperation
implements Versioned {
    private static final String NON_AVAILABLE_UUID = "n/a";
    private MembersViewMetadata membersViewMetadata;
    private long timestamp;

    public MasterConfirmationOp() {
    }

    public MasterConfirmationOp(MembersViewMetadata membersViewMetadata, long timestamp) {
        this.membersViewMetadata = membersViewMetadata;
        this.timestamp = timestamp;
    }

    @Override
    public void run() {
        Address endpoint = this.getCallerAddress();
        if (endpoint == null) {
            return;
        }
        if (this.membersViewMetadata == null) {
            String callerUuid = this.getCallerUuid();
            if (callerUuid == null) {
                callerUuid = NON_AVAILABLE_UUID;
            }
            this.membersViewMetadata = new MembersViewMetadata(endpoint, callerUuid, this.getNodeEngine().getThisAddress(), 0);
        }
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        clusterService.handleMasterConfirmation(this.membersViewMetadata, this.timestamp);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (VersionedClusterOperation.isGreaterOrEqualV39(out.getVersion())) {
            out.writeObject(this.membersViewMetadata);
        }
        out.writeLong(this.timestamp);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        if (VersionedClusterOperation.isGreaterOrEqualV39(in.getVersion())) {
            this.membersViewMetadata = (MembersViewMetadata)in.readObject();
        }
        this.timestamp = in.readLong();
    }

    @Override
    public int getId() {
        return 17;
    }
}

