/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.instance.MemberImpl;
import com.hazelcast.internal.cluster.impl.ClusterHeartbeatManager;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembersViewMetadata;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.internal.cluster.impl.operations.VersionedClusterOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;

public final class HeartbeatOp
extends AbstractClusterOperation
implements Versioned {
    private MembersViewMetadata senderMembersViewMetadata;
    private String targetUuid;
    private long timestamp;

    public HeartbeatOp() {
    }

    public HeartbeatOp(MembersViewMetadata senderMembersViewMetadata, String targetUuid, long timestamp) {
        this.senderMembersViewMetadata = senderMembersViewMetadata;
        this.targetUuid = targetUuid;
        this.timestamp = timestamp;
    }

    @Override
    public void run() {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        ClusterHeartbeatManager heartbeatManager = service.getClusterHeartbeatManager();
        if (this.senderMembersViewMetadata != null) {
            heartbeatManager.handleHeartbeat(this.senderMembersViewMetadata, this.targetUuid, this.timestamp);
        } else {
            MemberImpl member = this.getHeartBeatingMember(service);
            if (member != null) {
                heartbeatManager.onHeartbeat(member, this.timestamp);
            }
        }
    }

    private MemberImpl getHeartBeatingMember(ClusterServiceImpl service) {
        MemberImpl member = service.getMember(this.getCallerAddress());
        ILogger logger = this.getLogger();
        if (member == null) {
            if (logger.isFineEnabled()) {
                logger.fine("Heartbeat received from an unknown endpoint: " + this.getCallerAddress());
            }
            return null;
        }
        return member;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (VersionedClusterOperation.isGreaterOrEqualV39(out.getVersion())) {
            out.writeObject(this.senderMembersViewMetadata);
            out.writeUTF(this.targetUuid);
        }
        out.writeLong(this.timestamp);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        if (VersionedClusterOperation.isGreaterOrEqualV39(in.getVersion())) {
            this.senderMembersViewMetadata = (MembersViewMetadata)in.readObject();
            this.targetUuid = in.readUTF();
        }
        this.timestamp = in.readLong();
    }
}

